package com.byh.module.verlogin;

import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

import androidx.core.content.ContextCompat;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.bigkoo.pickerview.builder.OptionsPickerBuilder;
import com.bigkoo.pickerview.view.OptionsPickerView;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.present.PersonInfoPresent;
import com.byh.module.verlogin.view.IPersonInfosView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.entity.v2.HospitalEntityV2;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonalInfoVerifyView;
import com.kangxin.common.util.StringUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.http.api.Api;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

import static com.kangxin.common.byh.global.Global.CHANNEL_CODE;
import static com.kangxin.doctor.libdata.http.api.Api.HOS_APP_CODE;

/**
 * 个人信息
 */
@Route(path = VerloginRouter.PERSON_INFO)
public class PersonInfoActivity extends BaseActivity implements IToolView,
        View.OnClickListener, IPersonInfosView, IPersonalInfoVerifyView {

    private static final String TAG = "PersonInfoActivity";
    private TextView mYiyuanNameText;
    private TextView mSuozKeshiText;
    private TextView mSelZhiyText;
    private TextView mSelZhicText;
    private TextView mShanChlyText;
    private EditText mRealNameEdt;
    private PersonInfoPresent mPersonInfoPresent;
    private EditText mIdcardEdtView;

    private ArrayList<OccupationEntity> occupationEntities;
    private OccupationEntity selectOccupation;
    private ArrayList<JobTitleEntity> jobTitleEntities;
    private JobTitleEntity selectJobTitle;

    @Override
    public void start() {
        occupationEntities = new ArrayList<>();
        jobTitleEntities = new ArrayList<>();
        mPersonInfoPresent = new PersonInfoPresent(this);

        vToolTitleTextView.setText(R.string.person_info);
        mYiyuanNameText = findViewById(R.id.yiy_name);
        mYiyuanNameText.setOnClickListener(this);
        mSuozKeshiText = findViewById(R.id.suoz_keshi);
        mSuozKeshiText.setOnClickListener(this);
        mSelZhiyText = findViewById(R.id.sel_zhiy);
        mSelZhiyText.setOnClickListener(this);
        mSelZhicText = findViewById(R.id.sel_zhic);
        mSelZhicText.setOnClickListener(this);
        mShanChlyText = findViewById(R.id.shanc_liny);
        mShanChlyText.setOnClickListener(this);
        mRealNameEdt = findViewById(R.id.real_name_edt);
        mIdcardEdtView = findViewById(R.id.idcardnum_edt);
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.person_info_activity;
    }

    @Override
    public View getVToolView() {
        return rootView.findViewById(R.id.tool_bar);
    }

    @Override
    public void finishCurrentView() {
        finish();
    }

    @Override
    public void occupationSuccess(List<OccupationEntity> entityList) {
        occupationEntities.clear();
        occupationEntities.addAll(entityList);
        OptionsPickerView<OccupationEntity> pickerView = new OptionsPickerBuilder(this,
                (options1, option2, options3, v) -> {
                    if (selectOccupation != null && TextUtils.equals(selectOccupation.getTypeCode(), occupationEntities.get(options1).getTypeCode())) {
                        return;
                    }
                    selectOccupation = occupationEntities.get(options1);
                    mSelZhiyText.setText(selectOccupation.getTypeName());
                    mSelZhiyText.setTextColor(ContextCompat.getColor(getBaseContext(), R.color.gray_333333));
                    mSelZhicText.setText(getString(R.string.psel_xuanze));
                    mSelZhicText.setTextColor(ContextCompat.getColor(getBaseContext(), R.color.color_999999));
                    selectJobTitle = null;
                })
                .setSubmitText(getString(R.string.ver_ok))
                .setCancelText(getString(R.string.ver_cancel))
                .setTitleText(getString(R.string.psel_xuanze))
                .isCenterLabel(false)
                .build();
        pickerView.setPicker(occupationEntities);
        pickerView.show();
    }

    @Override
    public void jobTitleSuccess(List<JobTitleEntity> entities) {
        jobTitleEntities.clear();
        jobTitleEntities.addAll(entities);
        OptionsPickerView<JobTitleEntity> pickerView = new OptionsPickerBuilder(this,
                (options1, option2, options3, v) -> {
                    selectJobTitle = jobTitleEntities.get(options1);
                    mSelZhicText.setText(selectJobTitle.getDicName());
                    mSelZhicText.setTextColor(ContextCompat.getColor(getBaseContext(), R.color.gray_333333));
                })
                .setSubmitText(getString(R.string.ver_ok))
                .setCancelText(getString(R.string.ver_cancel))
                .setTitleText(getString(R.string.psel_xuanze))
                .isCenterLabel(false)
                .build();
        pickerView.setPicker(jobTitleEntities);
        pickerView.show();
    }

    @Override
    public void onClick(View view) {
        Intent intent = new Intent(this, FramePerInfoControActivity.class);
        int i = view.getId();
        if (i == R.id.sel_zhiy) {
            if (occupationEntities.isEmpty()) {
                mPersonInfoPresent.occupationList();
            } else {
                occupationSuccess(new ArrayList<>(this.occupationEntities));
            }
            return;
        } else if (i == R.id.sel_zhic) {
            if (selectOccupation == null) {
                showShortToast(getString(R.string.psel_suoznizhiy));
                return;
            }
            if (jobTitleEntities.isEmpty()) {
                mPersonInfoPresent.jobTitleList(selectOccupation.getTypeCode());
            } else if (TextUtils.equals(selectOccupation.getTypeCode(), jobTitleEntities.get(0).getParentCode())) {
                jobTitleSuccess(new ArrayList<>(this.jobTitleEntities));
            } else {
                mPersonInfoPresent.jobTitleList(selectOccupation.getTypeCode());
            }
            return;
        } else if (i == R.id.yiy_name) {
            intent.putExtra(Api.MSG_JUMP_TYPE, Api.JUMP_YIYUAN_NAME);
        } else if (i == R.id.suoz_keshi) {
            if (mHospitalEntity == null) {
                showShortToast(getString(R.string.psel_suosyy));
                return;
            }
            long hosId = Long.parseLong(mHospitalEntity.getHospitalId());
            String appCode = mHospitalEntity.getAppCode();
            intent.putExtra(Api.MSG_JUMP_TYPE, Api.JUMP_KESHI_NAME);
            intent.putExtra(HOS_APP_CODE, appCode);
            Log.i(TAG, "hosId==>" + hosId);
            intent.putExtra(Api.HOSPITAL_ID, hosId);
        } else if (i == R.id.shanc_liny) {
            intent.putExtra(Api.MSG_JUMP_TYPE, Api.JUMP_SHANCLY_NAME);
        }
        startActivity(intent);
    }

    private HospitalEntityV2 mHospitalEntity;
    private String mAreaCode;

    /**
     * 医院接收数据
     *
     * @param hosEntityEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveHosEntityEvent(ByhCommEvent.HosEntityEvent hosEntityEvent) {
        mHospitalEntity = hosEntityEvent.getmHosEntity();
        mAreaCode = mHospitalEntity.getDistrictCode();
        mYiyuanNameText.setText(mHospitalEntity.getHospitalName());
        mSuozKeshiText.setText(StringsUtils.getString(R.string.verlogin_qingxuanzeninsuozaikeshi));
    }

    private ByhCommEvent.HosDeptDataEvent mHosDeptData;

    /**
     * 科室接收数据
     *
     * @param hosDeptDataEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveKeshiDataEvent(ByhCommEvent.HosDeptDataEvent hosDeptDataEvent) {
        mHosDeptData = hosDeptDataEvent;
        mSuozKeshiText.setText(mHosDeptData.getStdDeptName());
    }

    private String mShancArea;

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveEvent(Event.ShancName shancName) {
        mShancArea = shancName.getShancDesc();
        String shancArea = StringUtil.changeSubText(mShancArea, 15);

        mShanChlyText.setText(shancArea);
    }

    /**
     * 职称实体
     */
    private SelZhicEntity mDictEntity;

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveZhicEntity(SelZhicEntity dictEntityListBean) {
        mDictEntity = dictEntityListBean;
        mSelZhicText.setText(mDictEntity.getDicName());
    }

    /**
     * 点击保存个人信息
     *
     * @param view
     */

    private String mRealName;

    public void clickSave(View view) {
        mRealName = mRealNameEdt.getText().toString().trim();
        if (TextUtils.isEmpty(mRealName)) {
            showShortToast(getString(R.string.p_input_realname));
            return;
        }


        if (mHospitalEntity == null) {
            showShortToast(getString(R.string.psel_suosyy));
            return;
        }

        if (mHosDeptData == null || mSuozKeshiText.getText().equals(StringsUtils.getString(R.string.verlogin_qingxuanzeninsuozaikeshi))) {
            showShortToast(getString(R.string.verlogin_psel_keshiname));
            return;
        }

        String keshiName = mSuozKeshiText.getText().toString();
        if (TextUtils.isEmpty(keshiName)) {
            showShortToast(getString(R.string.verlogin_psel_keshiname));
            return;
        }


        if (TextUtils.isEmpty(mSelZhiyText.getText().toString())) {
            showShortToast(getString(R.string.verlogin_psel_zhiye));
        }
        if (selectJobTitle == null || mSelZhicText.getText().toString().isEmpty()) {
            showShortToast(getString(R.string.psel_suoznizhic));
            return;
        }

        if (mSelZhicText.getText().toString().trim().equals(getString(R.string.psel_suoznizhic))) {
            showShortToast(getString(R.string.psel_suoznizhic));
            return;
        }

        if (TextUtils.isEmpty(mShancArea)) {
            showShortToast(getString(R.string.please_input_shancly));
            return;
        }

        //验证身份证与姓名是否一致
//        mVertifyPresent.updatePersonalInfo(idcardNum, realName);

        reqSavePersonInfo();
    }


    private PersonInfoBody personInfoBody;

    /**
     * 请求保存个人信息
     */
    private void reqSavePersonInfo() {

        String idcardNum = mIdcardEdtView.getText().toString().trim();
//        String realName = mRealNameEdt.getText().toString().trim();

        personInfoBody = new PersonInfoBody();
        LoginSuccess loginSuccess = VertifyDataUtil.getInstance(getApplicationContext()).getLoginData();
        String accountId = VertifyDataUtil.getInstance(getApplicationContext()).getLoginData().getAccountId();
        personInfoBody.setPhone(loginSuccess.getMobileNumber());
        personInfoBody.setAccountId(accountId);
        personInfoBody.setAreaCode(mAreaCode);
        personInfoBody.setChannelCode(CHANNEL_CODE);
        personInfoBody.setDisplayName(mRealName);
        personInfoBody.setAppCode(mHospitalEntity.getAppCode());
        personInfoBody.setHospitalId(mHospitalEntity.getHospitalId());
        personInfoBody.setHospitalCode(mHospitalEntity.getOrganCode());
        personInfoBody.setJob(mSelZhiyText.getText().toString());
        personInfoBody.setJobCode(selectOccupation.getTypeCode());
        personInfoBody.setProfession(selectJobTitle.getDicName());
        personInfoBody.setProfessionCode(selectJobTitle.getDicCode());
        personInfoBody.setHospitalDeptCode(mHosDeptData.getStdDeptId());
        personInfoBody.setHospitalDeptName(mHosDeptData.getHosDeptName());
        personInfoBody.setIdCardNo(idcardNum);


//        personInfoBody.setPosition(StringsUtils.getString(R.string.verlogin_xiangxidizhi)); //待确认
//        personInfoBody.setProfile(StringsUtils.getString(R.string.verlogin_gerenjianjie)); //待确认

        personInfoBody.setRegHospitalName(mHospitalEntity.getHospitalName());
        personInfoBody.setSpeciality(mShancArea);
        personInfoBody.setStdFristDeptCode(mHosDeptData.getStdFirstDeptCode());
        personInfoBody.setStdFristDeptName(mHosDeptData.getStdFirstDeptName());
        personInfoBody.setStdSecondDeptCode(mHosDeptData.getStdSecondDeptCode());
        personInfoBody.setStdSecondDeptName(mHosDeptData.getStdSecondDeptName());

        mPersonInfoPresent.savePersonInfo(getBaseContext(), personInfoBody);
    }

    @Override
    public void showErr(String msg) {
        showShortToast(msg);
    }

    @Override
    public void showPersonInfo(LoginSuccess responseBody) {
        ExpertInfoEntity expertInfoEntity = new ExpertInfoEntity();
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = new ExpertInfoEntity.UserInfoVOBean();
        userInfoVOBean.setName(mRealName);
        userInfoVOBean.setHospitalId(mHospitalEntity.getHospitalId());
        userInfoVOBean.setProfessionCode(selectJobTitle.getDicCode());
        userInfoVOBean.setJob(selectOccupation.getTypeName());
        userInfoVOBean.setJobCode(selectOccupation.getTypeCode());
        expertInfoEntity.setUserInfoVO(userInfoVOBean);
        VertifyDataUtil.getInstance(getBaseContext()).setDocDetailInfo(expertInfoEntity);
        VertifyDataUtil.getInstance().setOpenCode(mHospitalEntity.getAppCode());
        ARouter.getInstance().build(VerloginRouter.AUTHJOB_INFO).navigation();
        finish();
    }

    @Override
    public void showVerifyResult(ResponseBody responseBody) {
        reqSavePersonInfo();
    }

    @Override
    public void error(@Nullable String errorMsg) {
        showShortToast(errorMsg);
    }

  @Override
  public boolean initYm() {
    return false;
  }
}
