package com.byh.module.verlogin;

import android.util.Log;
import android.view.View;

import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.rmvp.BaseActivity;
import com.kangxin.common.byh.adapter.ErrorHeadIconSampleAdapter;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.present.impl.UpFilePresent;
import com.kangxin.common.byh.view.IUpFileView;
import com.kangxin.common.byh.widget.UpPicBottomDialog;
import com.kangxin.util.common.FileUtils;
import com.kangxin.common.util.StringsUtils;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.File;
import java.util.ArrayList;

import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

import static com.kangxin.common.byh.global.Global.IGONY_SIZE;
import static com.kangxin.common.byh.global.router.VerloginRouter.UPHEADERS_PAGE;

//上传头像
@Route(path = UPHEADERS_PAGE)
public class UpHeadIconActivity extends BaseActivity implements IUpFileView {

    private static final String TAG = "UpHeadIconActivity";
    private UpFilePresent mUpFilePresent;

    private RecyclerView mErrIconRecyclerView;
    private BaseQuickAdapter mAdapter = new ErrorHeadIconSampleAdapter(new ArrayList<>());

    private int[] icons = {R.mipmap.sample_head_top_more,
            R.mipmap.sample_face_more_big,
            R.mipmap.sample_msk,
            R.mipmap.sample_color_dark,
            R.mipmap.sample_background_error,
            R.mipmap.sample_clothes_error,
            R.mipmap.sample_cover
    };

    private String[] titles = {
            StringsUtils.getString(R.string.verlogin_toudingguogao),
            StringsUtils.getString(R.string.verlogin_mianbuguoda),
            StringsUtils.getString(R.string.verlogin_touxiangmohu),
            StringsUtils.getString(R.string.verlogin_guangxianguoan),
            StringsUtils.getString(R.string.verlogin_beijingzaluan),
            StringsUtils.getString(R.string.verlogin_chuanzhebianyi),
            StringsUtils.getString(R.string.verlogin_zhedangmianbu)
    };

    @Override
    public void goStart() {
        mErrIconRecyclerView = findViewById(R.id.vRecyclerView);

        registerClickUploadImgDialog(R.id.vUploadImage);
        mUpFilePresent = new UpFilePresent(this);

        initData();
        mErrIconRecyclerView.setLayoutManager(new GridLayoutManager(mContext, 3));
        mErrIconRecyclerView.setAdapter(mAdapter);
    }


    private void initData() {
        ArrayList<ErrorHeadIconSampleAdapter.IconErrorEntity> objects = new ArrayList<>();
        for (int i = 0; i < icons.length; i++) {
            objects.add(new ErrorHeadIconSampleAdapter.IconErrorEntity(icons[i], titles[i]));
        }
        mAdapter.setNewData(objects);
    }

    /**
     * 接收拍照或者相册传过来的图片
     *
     * @param uploadImgEvent
     */
    @Subscribe(threadMode = ThreadMode.MAIN)
    public void setImgByPath(ByhCommEvent.UploadImg uploadImgEvent) {
        if (uploadImgEvent.getViewId() == R.id.vUploadImage) {
            String path = uploadImgEvent.getPhotoInfoList().get(0);

            if (getBaseContext() == null) {
                return;
            }

            Luban.with(getBaseContext()).load(path).ignoreBy(IGONY_SIZE).setCompressListener(new OnCompressListener() {
                @Override
                public void onStart() {
                    Log.i(TAG, "==onStart====");
                }

                @Override
                public void onSuccess(File file) {
                    String filePath = file.getAbsolutePath();
                    String fileSize = FileUtils.getAutoFileOrFilesSize(filePath);
                    Log.i(TAG, "==onSuccess====fileSize==" + fileSize);
                    mUpFilePresent.upImgFile(filePath);
                }

                @Override
                public void onError(Throwable e) {
                    Log.i(TAG, "==onError==" + e.toString());
                }
            }).launch();
        }
    }

    /**
     * 对证件图片注册点击事件
     *
     * @param viewId 被点击的view id
     */
    private void registerClickUploadImgDialog(final int viewId) {
        findViewById(viewId).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                new UpPicBottomDialog(UpHeadIconActivity.this, viewId).show();
            }
        });
    }


    @Override
    public int getContentLayoutId() {
        return R.layout.worktab_by_fragment_person_head_upoad;
    }

    @Override
    public void showUpFileInfo(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
        EventBus.getDefault().postSticky(upImgEntityResponseBody.getResult());
        finish();
    }
}
