package com.byh.module.verlogin.fragment;


import android.util.Log;

import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.R;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.service.HosCityListService;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import static com.kangxin.common.byh.global.router.WorkTableRouter.HOS_PAGE_SERVICE;
import static com.kangxin.doctor.libdata.http.api.Api.HOSPITAL_ID;
import static com.kangxin.doctor.libdata.http.api.Api.HOS_APP_CODE;

public class KeshiNameFragment extends BaseFragment{

    private static final String TAG = "KeshiNameFragment";

    private long mHosId = -1;

    public static KeshiNameFragment getInstance(){
        return new KeshiNameFragment();
    }


    @Override
    public void init() {
        mHosId = getArguments().getLong(HOSPITAL_ID);
        //appCode-这个appCode是从医院列表数据中传进来的，并非本地保存的appCode
        String appCode = getArguments().getString(HOS_APP_CODE);
        Log.i(TAG, "hosId==>" + mHosId);
        if (mHosId != -1){
            HosCityListService hosCityListService = (HosCityListService) ARouter.getInstance().build(HOS_PAGE_SERVICE).navigation();
            loadRootFragment(R.id.frame_content, hosCityListService.getDepartmentFragment((int) mHosId, appCode));
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveKeshiDataEvent(ByhCommEvent.HosDeptDataEvent hosDeptDataEvent){
        getActivity().finish();
    }

    @Override
    protected int getLayoutId() {
        return R.layout.framcontent_fragment;
    }

}
