package com.byh.module.verlogin.fragment;

import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.graphics.Color;
import android.text.InputFilter;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.alibaba.android.arouter.launcher.ARouter;
import com.bigkoo.pickerview.builder.OptionsPickerBuilder;
import com.bigkoo.pickerview.view.OptionsPickerView;
import com.blankj.utilcode.util.ToastUtils;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.byh.module.verlogin.PersonInfoActivity;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.UpHeadIconActivity;
import com.byh.module.verlogin.present.PersonInfoPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.kangxin.common.Pretty;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.OccupationEntity;
import com.kangxin.common.byh.entity.VertifyIDCardEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.entity.response.UpImgEntity;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.present.IVerifyPresenter;
import com.kangxin.common.byh.present.VerifyPresenter;
import com.kangxin.common.byh.present.impl.DocOccPresent;
import com.kangxin.common.byh.present.impl.DocTypePresent;
import com.kangxin.common.byh.present.impl.UpFilePresent;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.DocTypeView;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.byh.view.IUpFileView;
import com.kangxin.common.byh.view.IVerNameByIdcardView;
import com.kangxin.common.byh.widget.DatePicker.CustomDatePicker;
import com.kangxin.common.byh.widget.TipsTextDialog;
import com.kangxin.common.byh.widget.UpPicBottomDialog;
import com.kangxin.common.byh.widget.photoSelect.FullyGridLayoutManager;
import com.kangxin.common.byh.widget.photoSelect.GlideCacheEngine;
import com.kangxin.common.byh.widget.photoSelect.GlideEngine;
import com.kangxin.common.byh.widget.photoSelect.GridImageAdapter;
import com.kangxin.common.util.AppManager;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.util.common.FileUtils;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.util.common.byh.StringUtil;
import com.luck.picture.lib.PictureSelector;
import com.luck.picture.lib.config.PictureConfig;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.decoration.GridSpacingItemDecoration;
import com.luck.picture.lib.entity.LocalMedia;
import com.luck.picture.lib.listener.OnResultCallbackListener;
import com.luck.picture.lib.style.PictureParameterStyle;
import com.luck.picture.lib.tools.ScreenUtils;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import top.zibin.luban.Luban;
import top.zibin.luban.OnCompressListener;

import static com.kangxin.common.byh.event.ByhCommEvent.UpdatePersonalCenter.REQUESTINTG_SUCCESS;
import static com.kangxin.common.byh.global.Global.IGONY_SIZE;

/**
 * 执业认证
 */

public class ProfesCertifyFragment extends BaseFragment implements IToolView, IUpFileView,
  IPersonInfoView, IVerNameByIdcardView, DocTypeView {

  private String TAG = "ProfesCertifyFragment";

  public static ProfesCertifyFragment getInstance() {
    return new ProfesCertifyFragment();
  }

  ImageView mUploadPersonPicView;
  ImageView mUploadCardId1View;
  ImageView mUploadCardId2View;
  ImageView mUploadCertifyView;
  private DocTypePresent mDocType;
  //    private DocOccPresent mDocOss;
  private UpFilePresent mUpFilePresent;
  private ByhCommEvent.UploadImg mUpimageEvent;
  private PersonInfoPresent mPersonInfoPresent;
  private EditText mIdCardNumEdtView,mHisNumEditView;
  private IVerifyPresenter mVertifyPresent;
  private EditText mUserNameEdtView;

  private RecyclerView mRecyclerView;
  private GridImageAdapter mAdapter;
  private int maxSelectNum = 6;// 最大图片选择数量
  private int chooseMode = PictureMimeType.ofImage();

  private String mDefaultUserName = null;

  private RelativeLayout mOccDisplay;
  private RelativeLayout mOccTimeDisplay;
  private RelativeLayout mQuailDisolay;
  private EditText mOccNumEdt;
  private TextView mOccTimeEdt;
  private EditText mQuailNumEdt;
  private String mIdOccNum;//执业证书编号
  private String mTimeStr;
  private String mIdQuailNum;
  private ImageView tip1, tip2, tip3, tip4;
  private int docType = 0;
  private String JobName = "";
  private String accountId = "";
  private TextView ic_down;

  private TextView vAddPatient;//nan
  private TextView vSelectPatient;//nv
  private TextView real_brid_edt;//nv
  private String selectSex = "1";//gender(1:男,2:女)
  private LinearLayout ll_btn_subHu;
  private String mBridStr = "";


  @Subscribe(threadMode = ThreadMode.MAIN, sticky = true)
  public void updatePersonInfoEvent(ByhCommEvent.UpdatePersonalCenter updatePersonalCenter) {
    switch (updatePersonalCenter.getStatus()) {
      case REQUESTINTG_SUCCESS:
        Log.i(TAG, "updatePersonInfoEvent: REQUESTINTG_SUCCESS");
        String professionCode = String.valueOf(VertifyDataUtil.getInstance(getContext()).getUserInfo().getProfessionCode());
        JobName = String.valueOf(VertifyDataUtil.getInstance(getContext()).getUserInfo().getJob());
        accountId = String.valueOf(VertifyDataUtil.getInstance(getContext()).getHospitalId());
        if (accountId == null || accountId.isEmpty()) {
          accountId = VertifyDataUtil.getInstance().getDocDetailInfo().getUserInfoVO().getHospitalId();
        }
//                mDocOss.verDocOss(professionCode);
        doctypeSuccess(JobName);
        mDocType.verDocType(accountId);
        break;
    }
  }

  private void showUserName() {
    ExpertInfoEntity.UserInfoVOBean userInfoVOBean =
      VertifyDataUtil.getInstance(getContext()).getUserInfo();
    LoginSuccess userInfoVOBeans =
      VertifyDataUtil.getInstance(mContext).getLoginData();
    if (userInfoVOBean != null) {
      String name = userInfoVOBean.getName();
      if (!TextUtils.isEmpty(name)) {
        mUserNameEdtView.setText(StringUtil.subNameToStarName(name));
      } else {
        mUserNameEdtView.setHint("***");
      }
    } else if (null != userInfoVOBeans) {
      String name = userInfoVOBeans.getName();
      if (!TextUtils.isEmpty(name)) {
        mUserNameEdtView.setText(StringUtil.subNameToStarName(name));
      } else {
        mUserNameEdtView.setHint("***");
      }
    } else {
      mUserNameEdtView.setHint("***");
    }


    mDefaultUserName = mUserNameEdtView.getText().toString().trim();


  }

  private String getDisplayName() {
    String currName = mUserNameEdtView.getText().toString().trim();
    if (mDefaultUserName != null) {
      if (mDefaultUserName.equals(currName)) {
        ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance(getContext()).getUserInfo();
        if (userInfoVOBean != null) {
          return userInfoVOBean.getName();
        }

        return null;
      }
    }

    return currName;
  }

  /**
   * @param viewId 被点击的view id
   */
  private void startDialog(final int viewId) {
    findViewById(rootView, viewId).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View view) {
        TipsTextDialog.getInstance().showDialogSetting(getActivity());
      }
    });
  }

  /**
   * 护照/身份证
   */
  private ArrayList<OccupationEntity> cardEntities = new ArrayList<>();
  private OccupationEntity cardOccupation;
  private TextView cardName;
  private int submitType = 2;//身份证模式
  private LinearLayout cardShow;
  private View line_card;
  private View line_sex;
  private RelativeLayout rela_card;
  private RelativeLayout rela_sex;


  public void cardNameView() {
    List<OccupationEntity> entityList = new ArrayList<>();
    OccupationEntity aVoid = new OccupationEntity();
    OccupationEntity aVoid1 = new OccupationEntity();
    aVoid.setTypeName("护照");
    aVoid1.setTypeName("身份证");
    entityList.add(aVoid);
    entityList.add(aVoid1);
    cardEntities.clear();
    cardEntities.addAll(entityList);
    OptionsPickerView<OccupationEntity> pickerView = new OptionsPickerBuilder(getActivity(),
      (options1, option2, options3, v) -> {
        cardOccupation = cardEntities.get(options1);
        cardName.setText(cardOccupation.getTypeName());
        cardName.setTextColor(ContextCompat.getColor(getActivity(), R.color.gray_333333));
        if (cardOccupation.getTypeName().equals("护照")) {
          submitType = 1;
          cardShow.setVisibility(View.GONE);
          line_card.setVisibility(View.VISIBLE);
          line_sex.setVisibility(View.VISIBLE);
          rela_sex.setVisibility(View.VISIBLE);
          rela_card.setVisibility(View.VISIBLE);
          mIdCardNumEdtView.setText("");
          mIdCardNumEdtView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(9)});
        } else {
          submitType = 2;
          cardShow.setVisibility(View.VISIBLE);
          line_card.setVisibility(View.GONE);
          line_sex.setVisibility(View.GONE);
          rela_sex.setVisibility(View.GONE);
          rela_card.setVisibility(View.GONE);
          mIdCardNumEdtView.setFilters(new InputFilter[]{new InputFilter.LengthFilter(18)});
          real_brid_edt.setText("");
          mIdCardNumEdtView.setText("");
        }
      })
      .setSubmitText(getString(R.string.bothreferral_queding))
      .setCancelText(getString(R.string.bothreferral_quxiao))
      .isCenterLabel(false)
      .build();
    pickerView.setPicker(cardEntities);
    pickerView.show();
  }

  @Override
  public void init() {
    mVertifyPresent = new VerifyPresenter(this);
    mDocType = new DocTypePresent(this);
//        mDocOss = new DocOccPresent(this);

    mOccNumEdt = findViewById(rootView, R.id.et_occ_edt);
    mOccTimeEdt = findViewById(rootView, R.id.et_occ_time_edt);//执业证书发证日期
    mQuailNumEdt = findViewById(rootView, R.id.et_quail_edt);//资质证书编号
    mOccDisplay = findViewById(rootView, R.id.rl_occ_display);
    mOccTimeDisplay = findViewById(rootView, R.id.rl_occ_time_display);
    mQuailDisolay = findViewById(rootView, R.id.rl_quail_display);
    p_occ_number = findViewById(rootView, R.id.p_occ_number);
    p_occ_time = findViewById(rootView, R.id.p_occ_time);
    p_quail_number = findViewById(rootView, R.id.p_quail_number);
    mHisNumEditView = findViewById(rootView,R.id.id_his_num_edt);

    mUploadPersonPicView = findViewById(rootView, R.id.add_per_pic);
    mUploadCardId1View = findViewById(rootView, R.id.add_cardid1);
    mUploadCardId2View = findViewById(rootView, R.id.add_cardid2);
    mUploadCertifyView = findViewById(rootView, R.id.add_certify);
    mIdCardNumEdtView = findViewById(rootView, R.id.idcardnum_edt);
    mUserNameEdtView = findViewById(rootView, R.id.real_name_edt);
    ll_btn_subHu = findViewById(rootView, R.id.ll_btn_subHu);
    tip1 = findViewById(rootView, R.id.tip1);
    tip2 = findViewById(rootView, R.id.tip2);
    tip3 = findViewById(rootView, R.id.tip3);
    tip4 = findViewById(rootView, R.id.tip4);
//        mRecyclerView = findViewById(rootView, R.id.recycler_id);

    vAddPatient = findViewById(rootView, R.id.vAddPatient);
    vSelectPatient = findViewById(rootView, R.id.vSelectPatient);
    real_brid_edt = findViewById(rootView, R.id.real_brid_edt);
    cardName = findViewById(rootView, R.id.cardName);
    cardShow = findViewById(rootView, R.id.cardShow);
    line_card = findViewById(rootView, R.id.line_card);
    line_sex = findViewById(rootView, R.id.line_sex);
    rela_card = findViewById(rootView, R.id.rela_card);
    rela_sex = findViewById(rootView, R.id.rela_sex);
    ic_down = findViewById(rootView, R.id.ic_down);


    accountId = String.valueOf(VertifyDataUtil.getInstance(getContext()).getHospitalId());
    if (accountId == null || accountId.isEmpty()) {
      accountId = VertifyDataUtil.getInstance().getDocDetailInfo().getUserInfoVO().getHospitalId();
    }

    mDocType.verDocType(accountId);

    if (VertifyDataUtil.getInstance().PassportOrID()) {
      ic_down.setVisibility(View.VISIBLE);
      startDialog(R.id.ll_btn_subHu);
      ll_btn_subHu.setOnClickListener(v -> {
        cardNameView();
      });
    } else {
      ic_down.setVisibility(View.GONE);
      ll_btn_subHu.setOnClickListener(null);
    }

    showUserName();
//        initselectPic();

    mPersonInfoPresent = new PersonInfoPresent(this);
    mUpFilePresent = new UpFilePresent(this);
    vToolTitleTextView.setText(R.string.profes_certify);
    vRightTextView.setText(R.string.per_skip);
    vRightTextView.setVisibility(View.VISIBLE);
    vRightTextView.setTextColor(Color.WHITE);
    vRightTextView.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
      }
    });

    mUploadPersonPicView.setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        startActivity(new Intent(getContext(),
          UpHeadIconActivity.class));
      }
    });

    registerClickUploadImgDialog(R.id.add_cardid1);
    registerClickUploadImgDialog(R.id.add_cardid2);
    registerClickUploadImgDialog(R.id.add_certify);
    startDialog(R.id.tip1);
    startDialog(R.id.tip2);
    startDialog(R.id.tip3);
    startDialog(R.id.tip4);


    real_brid_edt.setOnClickListener(v -> {
      getDataOf(real_brid_edt);
    });

    mOccTimeEdt.setOnClickListener(v -> {
      getDataOf(mOccTimeEdt);
    });

    findViewById(rootView, R.id.ci_certify).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View view) {

        mTimeStr = mOccTimeEdt.getText().toString().trim();


        if (!isUpHeaderIcon) {
          showShortToast(StringsUtils.getString(R.string.verlogin_qingshangchuantouxiang));
          return;
        }

        String idcardNum = mIdCardNumEdtView.getText().toString().trim();

        String userName = getDisplayName();

        if (mUserNameEdtView.getText().toString().isEmpty()) {
          ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_qingtianxieyishengxingming));
          return;
        }

        boolean idcardIsNull = TextUtils.isEmpty(idcardNum);//身份证判空

        if (idcardIsNull) {
          if (submitType == 1) {
            showShortToast(StringsUtils.getString(R.string.verlogin_qingshangchuanhuzhap));
          } else {
            showShortToast(StringsUtils.getString(R.string.verlogin_qingshangchuanshenfenzheng));
          }
          return;
        } else {
          if (submitType == 1) {
            if (idcardNum.length() != 9) {
              showShortToast(StringsUtils.getString(R.string.verlogin_qingshangchuanhuzhap_error));
              return;
            }
          }
        }

        mBridStr = real_brid_edt.getText().toString().trim();

        //1 护照  2 身份证
        if (submitType == 1) {
          if (mBridStr == null || mBridStr.isEmpty()) {
            showShortToast(StringsUtils.getString(R.string.verlogin_psel_chushengriqi));
            return;
          }
          if (selectSex == null || selectSex.isEmpty()) {
            showShortToast(StringsUtils.getString(R.string.verlogin_psel_xingbie));
            return;
          }
        }

        if (!isUpVertifyCard) {
          showShortToast(StringsUtils.getString(R.string.verlogin_qingshangchuanzhiyezhengshu));
          return;
        }

        if(mHisNumEditView.getText().toString().trim().length()==0){
          showShortToast("请输入HIS工号");
          return;
        }

        /**
         *     private RelativeLayout mOccDisplay;
         *     private RelativeLayout mOccTimeDisplay;
         *     private RelativeLayout mQuailDisolay;
         */
        if (mOccDisplay.getVisibility() == View.VISIBLE) {//护士
          mIdOccNum = mOccNumEdt.getText().toString().trim();
          if (mIdOccNum == null || mIdOccNum.isEmpty()) {
            showShortToast(StringsUtils.getString(R.string.worktab_zhiyezhengshubianhao));
            return;
          }
        }
        if (mQuailDisolay.getVisibility() == View.VISIBLE) {
          mIdQuailNum = mQuailNumEdt.getText().toString().trim();
          if (mIdQuailNum == null || mIdQuailNum.isEmpty()) {
            showShortToast(StringsUtils.getString(R.string.worktab_zigezhengshubianhao));
            return;
          }
        }
        if (mOccTimeDisplay.getVisibility() == View.VISIBLE) {
          if (mTimeStr == null || mTimeStr.isEmpty()) {
            showShortToast(StringsUtils.getString(R.string.worktab_zhiyezhengshuriqi));
            return;
          }
        }
        if (!idcardIsNull && submitType == 2) {
          idcardNum = VerifyUtil.changeIdcard(idcardNum);

          if (!VerifyUtil.isIdNo(idcardNum)) {
            showShortToast(getString(R.string.ver_idcard_err));
            return;
          }

          if (!TextUtils.isEmpty(userName)) {
            mVertifyPresent.verNameByIdcard(getContext(), userName, idcardNum);
          } else {

            ExpertInfoEntity.UserInfoVOBean userInfoVOBean = VertifyDataUtil.getInstance(getContext()).getUserInfo();

            if (userInfoVOBean != null) {
              String localUserName = userInfoVOBean.getName();
              if (!TextUtils.isEmpty(localUserName)) {
                mVertifyPresent.verNameByIdcard(getContext(), localUserName, idcardNum);
              } else {
                ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_qingtianxieyishengxingming));
              }
            }
          }
        } else {
          ReqWebBody reqWebBody = new ReqWebBody();
          String accountId = VertifyDataUtil.getInstance(getContext()).getLoginData().getAccountId();
          reqWebBody.setAccountId(accountId);

          if (submitType == 1) {
            reqWebBody.setGender(selectSex);
            reqWebBody.setDateOfBirth(mBridStr);
            reqWebBody.setCredTypeCode("02");
          } else {
            reqWebBody.setCredTypeCode("01");
          }


          if (!TextUtils.isEmpty(userName)) {
            reqWebBody.setDisplayName(userName);
          }
          if (docOssType != -1) {
            if (mOccDisplay.getVisibility() == View.VISIBLE) {
              reqWebBody.setDoctorWorkCode(mIdOccNum);//职业
            }
            if (mQuailDisolay.getVisibility() == View.VISIBLE) {
              reqWebBody.setDoctorCertCode(mIdQuailNum);//资格
            }
            reqWebBody.setDoctorworkDate(mTimeStr);

          }
          reqWebBody.setBadgeUrl(mBadgeUrl);
          reqWebBody.setHeadImageUrl(mHeaderImageUrl);
          reqWebBody.setIdCardBack(mIdcardBack);
          reqWebBody.setIdCardFront(mIdcardFront);
          reqWebBody.setIdCardNo(idcardNum);
          reqWebBody.setEmplCode(mHisNumEditView.getText().toString().trim());
          mPersonInfoPresent.saveCertifyInfo(getContext(), reqWebBody);
        }

      }
    });

    //男
    vAddPatient.setOnClickListener(v -> {
      selectSex = "1";
      vSelectPatient.setTextColor(Color.parseColor("#888C91"));
      vSelectPatient.setBackgroundDrawable(getResources().getDrawable(R.drawable.by_background_gray_consul));
      vAddPatient.setTextColor(Color.parseColor("#3576E0"));
      vAddPatient.setBackgroundDrawable(getResources().getDrawable(R.drawable.by_background_circle_blue_full));
    });

    //女
    vSelectPatient.setOnClickListener(v -> {
      selectSex = "2";
      vAddPatient.setTextColor(Color.parseColor("#888C91"));
      vAddPatient.setBackgroundDrawable(getResources().getDrawable(R.drawable.by_background_gray_consul));
      vSelectPatient.setTextColor(Color.parseColor("#3576E0"));
      vSelectPatient.setBackgroundDrawable(getResources().getDrawable(R.drawable.by_background_circle_blue_full));
    });

  }


  void getDataOf(View view) {
    // 回调接口，获得选中的时间
    CustomDatePicker customDatePickerStart = new CustomDatePicker(mContext, mContext.getResources().getString(R.string.please_select_date_tips), time -> {
      mStartTimeStr = time.split(" ")[0];
      mOccTimeEdt.setTextColor(getResources().getColor(R.color.color_333333));
      if (view.getId() == R.id.et_occ_time_edt) {
        mOccTimeEdt.setText(mStartTimeStr.substring(0, 10));
      } else {
        real_brid_edt.setText(mStartTimeStr.substring(0, 10));
      }
    }, "1950-01-01 00:00", getCurTime(), new CustomDatePicker.DialogShowOrDismiss() {
      @Override
      public void show() {

      }

      @Override
      public void dismiss() {

      }
    }); // 初始化日期格式请用：yyyy-MM-dd HH:mm，否则不能正常运行
    customDatePickerStart.showSpecificTime(false); // 显示时和分
    customDatePickerStart.setIsLoop(false); // 允许循环滚动
    customDatePickerStart.show(stampToDate(System.currentTimeMillis()));
  }

  @Override
  public void vertifySuccess(VertifyIDCardEntity vertifyIDCardEntity) {
    ReqWebBody reqWebBody = new ReqWebBody();
    String accountId = VertifyDataUtil.getInstance(getContext()).getLoginData().getAccountId();

    if (submitType == 1) {
      reqWebBody.setGender(selectSex);
      reqWebBody.setDateOfBirth(mBridStr);
      reqWebBody.setCredTypeCode("02");
    } else {
      reqWebBody.setCredTypeCode("01");
    }

    reqWebBody.setDisplayName(vertifyIDCardEntity.getName());
    reqWebBody.setAccountId(accountId);
    reqWebBody.setBadgeUrl(mBadgeUrl);
    reqWebBody.setHeadImageUrl(mHeaderImageUrl);
    reqWebBody.setIdCardBack(mIdcardBack);
    reqWebBody.setIdCardFront(mIdcardFront);
    reqWebBody.setDoctorworkDate(mTimeStr);//
    reqWebBody.setDoctorWorkCode(mIdOccNum);
    reqWebBody.setDoctorCertCode(mIdQuailNum);
    reqWebBody.setIdCardNo(vertifyIDCardEntity.getIdcard());
    reqWebBody.setEmplCode(mHisNumEditView.getText().toString().trim());
    mPersonInfoPresent.saveCertifyInfo(getContext(), reqWebBody);
  }

  /**
   * 将时间戳转换为时间
   *
   * @param timeMillis
   * @return
   */
  private String mStartTimeStr;

  public String getCurTime() {
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.CHINA);
    return sdf.format(new Date());
  }

  public String stampToDate(long timeMillis) {
    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    Date date = new Date(timeMillis);
    return simpleDateFormat.format(date);
  }

  private void initselectPic() {
    FullyGridLayoutManager manager = new FullyGridLayoutManager(getActivity(),
      4, GridLayoutManager.VERTICAL, false);
    mRecyclerView.setLayoutManager(manager);
    mRecyclerView.addItemDecoration(new GridSpacingItemDecoration(4,
      ScreenUtils.dip2px(getContext(), 8), false));
    mAdapter = new GridImageAdapter(getContext(), onAddPicClickListener);
    mAdapter.setSelectMax(maxSelectNum);
    mRecyclerView.setAdapter(mAdapter);
    mAdapter.setOnItemClickListener((v, position) -> {
      List<LocalMedia> selectList = mAdapter.getData();
      if (selectList.size() > 0) {
        LocalMedia media = selectList.get(position);
        String mimeType = media.getMimeType();
        int mediaType = PictureMimeType.getMimeType(mimeType);
        switch (mediaType) {//目前只有图片没有其他格式
          case PictureConfig.TYPE_VIDEO:
            // 预览视频
            PictureSelector.create(ProfesCertifyFragment.this)
              .themeStyle(R.style.picture_default_style)
              .setPictureStyle(mPictureParameterStyle)// 动态自定义相册主题
              .externalPictureVideo(TextUtils.isEmpty(media.getAndroidQToPath()) ? media.getPath() : media.getAndroidQToPath());
            break;
          case PictureConfig.TYPE_AUDIO:
            // 预览音频
            PictureSelector.create(ProfesCertifyFragment.this)
              .externalPictureAudio(PictureMimeType.isContent(media.getPath()) ? media.getAndroidQToPath() : media.getPath());
            break;
          default:
            // 预览图片 可自定长按保存路径
            PictureSelector.create(ProfesCertifyFragment.this)
              .themeStyle(R.style.picture_default_style) // xml设置主题
              .setPictureStyle(mPictureParameterStyle)// 动态自定义相册主题
              //.setPictureWindowAnimationStyle(animationStyle)// 自定义页面启动动画
              .setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT)// 设置相册Activity方向，不设置默认使用系统
              .isNotPreviewDownload(true)// 预览图片长按是否可以下载
              //.bindCustomPlayVideoCallback(callback)// 自定义播放回调控制，用户可以使用自己的视频播放界面
              .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
              .openExternalPreview(position, selectList);
            break;
        }
      }
    });
  }

  private PictureParameterStyle mPictureParameterStyle;
  private GridImageAdapter.onAddPicClickListener onAddPicClickListener = new GridImageAdapter.onAddPicClickListener() {
    @Override
    public void onAddPicClick() {
      // 进入相册 以下是例子：不需要的api可以不写
      PictureSelector.create(getActivity())
        .openGallery(chooseMode)// 全部.PictureMimeType.ofAll()、图片.ofImage()、视频.ofVideo()、音频.ofAudio()
        .loadImageEngine(GlideEngine.createGlideEngine())// 外部传入图片加载引擎，必传项
        .loadCacheResourcesCallback(GlideCacheEngine.createCacheEngine())// 获取图片资源缓存，主要是解决华为10部分机型在拷贝文件过多时会出现卡的问题，这里可以判断只在会出现一直转圈问题机型上使用
        .maxSelectNum(maxSelectNum)// 最大图片选择数量
        .minSelectNum(1)// 最小选择数量
        .maxVideoSelectNum(maxSelectNum) // 视频最大选择数量，如果没有单独设置的需求则可以不设置，同用maxSelectNum字段
        .imageSpanCount(4)// 每行显示个数
        .isReturnEmpty(false)// 未选择数据时点击按钮是否可以返回
        .selectionMode(PictureConfig.MULTIPLE)// 多选 or 单选
        .isCamera(false)// 是否显示拍照按钮
        .isZoomAnim(true)// 图片列表点击 缩放效果 默认true
        .enableCrop(true)// 是否裁剪
        .compress(true)// 是否压缩
        //.compressQuality(80)// 图片压缩后输出质量 0~ 100
        .synOrAsy(true)//同步true或异步false 压缩 默认同步
        .selectionMedia(mAdapter.getData())// 是否传入已选图片
        .cutOutQuality(90)// 裁剪输出质量 默认100
        .minimumCompressSize(100)// 小于100kb的图片不压缩
        .forResult(new OnResultCallbackListener<LocalMedia>() {
          @Override
          public void onResult(List<LocalMedia> result) {
            if (result != null) {
              mAdapter.setList(result);
              mAdapter.notifyDataSetChanged();
            }
          }

          @Override
          public void onCancel() {
            Log.i(TAG, "PictureSelector Cancel");
          }
        });
    }

  };


  /**
   * 接收拍照或者相册传过来的图片
   *
   * @param uploadImgEvent
   */
  @Subscribe(threadMode = ThreadMode.MAIN)
  public void setImgByPath(ByhCommEvent.UploadImg uploadImgEvent) {

    if (uploadImgEvent.getViewId() != R.id.vUploadImage) {
      mUpimageEvent = uploadImgEvent;

      String path = uploadImgEvent.getPhotoInfoList().get(0);


      if (getContext() == null) {
        return;
      }
      Luban.with(getContext()).load(path).ignoreBy(IGONY_SIZE).setCompressListener(new OnCompressListener() {
        @Override
        public void onStart() {
          Log.i(TAG, "==onStart====");
        }

        @Override
        public void onSuccess(File file) {
          String filePath = file.getAbsolutePath();
          String fileSize = FileUtils.getAutoFileOrFilesSize(filePath);
          Log.i(TAG, "==onSuccess====fileSize==" + fileSize);
          mUpFilePresent.upImgFile(filePath);
        }

        @Override
        public void onError(Throwable e) {
          Log.i(TAG, "==onError==" + e.toString());
        }
      }).launch();
    }
  }

  /**
   * 显示上传成功之后的图片
   *
   * @param path
   * @param imageView
   */
  private void showUploadImg(String path, ImageView imageView) {
    Log.i(TAG, "==showUploadImg==>" + path);
    if (null == mUpimageEvent) {
      Pretty.create().loadImage(path)
        .diskCacheStrategy(DiskCacheStrategy.NONE)
        .into(imageView);
    } else {
      if (mUpimageEvent.getViewId() == R.id.add_cardid1) {
        mUploadCardId1View.setImageResource(R.drawable.ic_yijiami);
      } else if (mUpimageEvent.getViewId() == R.id.add_cardid2) {
        mUploadCardId2View.setImageResource(R.drawable.ic_yijiami);
      } else {
        Pretty.create().loadImage(path)
          .diskCacheStrategy(DiskCacheStrategy.NONE)
          .into(imageView);
      }
    }
  }

  /**
   * 对证件图片注册点击事件
   *
   * @param viewId 被点击的view id
   */
  private void registerClickUploadImgDialog(final int viewId) {
    findViewById(rootView, viewId).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View view) {
        new UpPicBottomDialog(getActivity(), viewId).show();
      }
    });
  }

  @Override
  public View getVToolView() {
    return rootView.findViewById(R.id.vToolBar);
  }

  @Override
  public void finishCurrentView() {
    if (getActivity() != null) {
      getActivity().finish();
    }
  }

  /**
   * 个人头像
   */
  private String mHeaderImageUrl;
  /**
   * 身份证正面
   */
  private String mIdcardFront;
  /**
   * 身份证反面
   */
  private String mIdcardBack;
  /**
   * 证书
   */
  private String mBadgeUrl;
  /**
   * 身份证号码
   */
  private String mIdcardNo;
  private boolean isUpHeaderIcon = false;
  private boolean isUpIdcard1 = false;
  private boolean isUpIdcard2 = false;
  private boolean isUpVertifyCard = false;


  @Subscribe(threadMode = ThreadMode.MAIN)
  public void showUpHeaderIconEvent(UpImgEntity upImgEntity) {
    mHeaderImageUrl = upImgEntity.getUrl();
    showUploadImg(mHeaderImageUrl, mUploadPersonPicView);
    isUpHeaderIcon = true;
  }

  /**
   * 图片上传成功之后的操作
   *
   * @param upImgEntityResponseBody
   */
  @Override
  public void showUpFileInfo(ResponseBody<UpImgEntity> upImgEntityResponseBody) {
    Log.i(TAG, "upImgEntityResponseBody==>" + upImgEntityResponseBody.getResult());

    String imgUrl = upImgEntityResponseBody.getResult().getUrl();
    if (mUpimageEvent.getViewId() == R.id.add_cardid1) {
      mIdcardFront = imgUrl;
      showUploadImg(mIdcardFront, mUploadCardId1View);
      isUpIdcard1 = true;

    } else if (mUpimageEvent.getViewId() == R.id.add_cardid2) {
      mIdcardBack = imgUrl;
      showUploadImg(mIdcardBack, mUploadCardId2View);
      isUpIdcard2 = true;

    } else if (mUpimageEvent.getViewId() == R.id.add_certify) {
      mBadgeUrl = imgUrl;
      showUploadImg(mBadgeUrl, mUploadCertifyView);
      isUpVertifyCard = true;

    }
  }


  @Override
  public void showErr(String msg) {
    showShortToast(msg);
  }

  @Override
  public void showPersonInfo(LoginSuccess responseBody) {
    UpdateVerStatus.getInstance().updateDocDetailInfo(getContext(), null);

    replaceFragment(CertifyOkFragment.getInstance(), false);
    AppManager.getAppManager().finishActivity(PersonInfoActivity.class);
  }


  /**
   * 校验是否对接平台
   *
   * @param type
   */
  @Override
  public void doctypeSuccess(int type) {
    this.docType = type;
    //1 对接         非1 未对接
    getActivity().runOnUiThread(new Runnable() {
      @Override
      public void run() {
        if (docType != 1) {
          mOccDisplay.setVisibility(View.GONE);
          mOccTimeDisplay.setVisibility(View.GONE);
          mQuailDisolay.setVisibility(View.GONE);
        } else {
          if (!JobName.isEmpty()) {
            docOssType = 1;
            doctypeSuccess(JobName);
          }
        }
      }
    });
  }

  /**
   * 获取用户职称类型
   *
   * @param docOss
   */

  int docOssType = 0;
  private TextView p_occ_number;//p_zhiye_number
  private TextView p_occ_time;//p_zhiye_time
  private TextView p_quail_number;//p_zizhi_number

  @Override
  public void doctypeSuccess(String docOss) {
    if (docOssType == -1) {
      return;
    }
    if (accountId.equals("34")) {
      if (docOss.equals("医生")) {
        mOccDisplay.setVisibility(View.VISIBLE);
        mOccTimeDisplay.setVisibility(View.GONE);
        mQuailDisolay.setVisibility(View.GONE);
      } else {
        mOccDisplay.setVisibility(View.GONE);
        mOccTimeDisplay.setVisibility(View.GONE);
        mQuailDisolay.setVisibility(View.GONE);
      }
    } else {
      if (docOss.equals("医生")) {
        mOccDisplay.setVisibility(View.VISIBLE);
        mOccTimeDisplay.setVisibility(View.VISIBLE);
        mQuailDisolay.setVisibility(View.VISIBLE);
        p_occ_time.setText(R.string.p_zhiye_time);
      } else if (docOss.equals("护士")) {
        mOccDisplay.setVisibility(View.VISIBLE);
        mOccTimeDisplay.setVisibility(View.VISIBLE);
        p_occ_time.setText(R.string.p_zige_time);
        mQuailDisolay.setVisibility(View.GONE);
      } else if (docOss.equals("药师")) {
        //药师
        p_occ_time.setText(R.string.p_zige_time);
        mOccDisplay.setVisibility(View.GONE);
        mOccTimeDisplay.setVisibility(View.VISIBLE);
        mQuailDisolay.setVisibility(View.VISIBLE);
      } else {
        docOssType = -1;
        mOccDisplay.setVisibility(View.GONE);
        mOccTimeDisplay.setVisibility(View.GONE);
        mQuailDisolay.setVisibility(View.GONE);
      }
    }
  }

  @Override
  protected int getLayoutId() {
    return R.layout.profes_vertify_fragment;
  }
}

