package com.byh.module.verlogin.module;

import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;

import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.PwdParam;
import com.byh.module.verlogin.entity.UpdatePhoneParam;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;

public class ChangePhoneViewModel extends ViewModel {

  private VerLoginModule mVerLoginModule;

  public MutableLiveData<String> getCodeByPhone(String mPhoneNum){
    MutableLiveData<String> key = new MutableLiveData<String>();
    mVerLoginModule = new VerLoginModule();
    mVerLoginModule.sendSmsAuthCode(mPhoneNum)
      .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
        @Override
        public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
            key.setValue(loginSuccessResponseBody.getResult().getAuthKey());
            ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_fasongchenggong));
        }

        @Override
        public void onReqErr(Throwable e) {
            ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_fasongchenggong_shibai));
        }
      });
    return key;
  }

  public MutableLiveData<ResponseBody> checkCode(String code,String authKey){
    MutableLiveData<ResponseBody> msg = new MutableLiveData<ResponseBody>();
    mVerLoginModule = new VerLoginModule();
    ReqWebBody reqWebBody = new ReqWebBody();
    reqWebBody.setAuthCode(code);
    reqWebBody.setAuthKey(authKey);
    reqWebBody.setOperate("D");
    mVerLoginModule.validatePhoneAndCode(reqWebBody)
      .subscribe(new RxProgressObserver<ResponseBody>() {
        @Override
        public void onReqNext(ResponseBody responseBody) {
          msg.setValue(responseBody);
        }

        @Override
        public void onReqErr(int code, String msgs, String errCode) {
          ResponseBody response = new ResponseBody();
          response.setCode("0");
          response.setMsg(msgs);
          msg.setValue(response);
        }
      });

    return msg;
  }

  public MutableLiveData<ResponseBody> checkPwdForNewPhone(String accountNo,String pwd){
    MutableLiveData<ResponseBody> result = new MutableLiveData<ResponseBody>();
    mVerLoginModule = new VerLoginModule();
    PwdParam pwdParam = new PwdParam();
    pwdParam.setLoginPwd(pwd);
    pwdParam.setAccountNo(accountNo);
    mVerLoginModule.checkPwdForNewPhoneNum(pwdParam)
      .subscribe(new RxProgressObserver<ResponseBody>() {
        @Override
        public void onReqNext(ResponseBody responseBody) {
            result.setValue(responseBody);
        }
      });

    return result;
  }

  public MutableLiveData<ResponseBody> updateNewPhoneNum(String accountNo,String channel,String phone){
    MutableLiveData<ResponseBody> result = new MutableLiveData<ResponseBody>();
    mVerLoginModule = new VerLoginModule();
    UpdatePhoneParam phoneParam = new UpdatePhoneParam();
    phoneParam.setPhoneNumber(phone);
    phoneParam.setChannelCode(channel);
    phoneParam.setAccountNo(accountNo);
    mVerLoginModule.updateNewPhoneNum(phoneParam)
      .subscribe(new RxProgressObserver<ResponseBody>() {
        @Override
        public void onReqNext(ResponseBody responseBody) {
          result.setValue(responseBody);
        }
      });

    return result;
  }

}
