package com.byh.module.verlogin.present;

import android.content.Context;

import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.AddHospitalView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.rx.ProgressDialogObserver;

public class AddHospitalPresent {
    private VerLoginModule mLoginModule;
    private AddHospitalView mAddHosView;

    public AddHospitalPresent(AddHospitalView mAddHosView) {
        this.mAddHosView = mAddHosView;
        mLoginModule = new VerLoginModule();
    }

    public void addHospitalInfo(String hospitalName, Long doctorId, String distCode){
        mLoginModule.addHospitalInfo(hospitalName, doctorId, distCode)
                .subscribe(new ProgressDialogObserver<ResponseBody>() {
                    @Override
                    public void onNext(ResponseBody responseBody) {
                        if (responseBody.getCode()!=200){
                            mAddHosView.error(responseBody.getMsg());
                            return;
                        }

                        mAddHosView.addHosOk(responseBody.getResult()+"");
                    }

                    @Override
                    protected Context attachContext() {
                        return mAddHosView.injectContext();
                    }
                });
    }


    public void addHosDepartment(String departmentName,
                                 Long stdFirstDepId,
                                 Long hospitalId,
                                 Long doctorId){

        mLoginModule.addHosDepartment(departmentName, stdFirstDepId, hospitalId, doctorId)
                .subscribe(new ProgressDialogObserver<ResponseBody>() {
                    @Override
                    public void onNext(ResponseBody responseBody) {

                        if (responseBody.getCode() != 200){
                            mAddHosView.error(responseBody.getMsg());
                            return;
                        }

                        mAddHosView.addHosOk(responseBody.getResult()+"");
                    }

                    @Override
                    protected Context attachContext() {
                        return mAddHosView.injectContext();
                    }
                });

    }
}
