package com.byh.module.verlogin.present;

import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IForgetPwdView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.widget.RxProgressObserver;

public class ForgetResetLoginPresent {

    private static final String TAG = "ForgetResetLoginPresent";
    private IForgetPwdView mIForgetView;
    private VerLoginModule mVerLoginModule;

    public ForgetResetLoginPresent(IForgetPwdView iForgetView) {
        this.mIForgetView = iForgetView;
        mVerLoginModule = new VerLoginModule();
    }

    public void resetLoginPwd(String phone,  String password){

        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setPassword(password);
        reqWebBody.setAccountNo(phone);

        mVerLoginModule.setForgetResetPwdPersonInfo(reqWebBody)
              .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
                  @Override
                  public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                      mIForgetView.setPwdOk(loginSuccessResponseBody.getCode()+"");
                  }
              });


    }
}
