package com.byh.module.verlogin.present;

import android.content.Context;
import android.util.Log;

import com.byh.module.verlogin.view.IGetKeshiView;
import com.kangxin.common.byh.entity.MenuDepartmentList;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.module.IMenuDepartmentListModel;
import com.kangxin.common.byh.module.impl.MenuDeptListModel;
import com.kangxin.common.rx.ProgressDialogObserver;

import java.util.List;

public class KeshiListPresent {

    private IMenuDepartmentListModel mLoginModule;
    private IGetKeshiView mKeshiView;
    private String TAG = "KeshiListPresent";

    public KeshiListPresent(IGetKeshiView mKeshiView) {
        this.mKeshiView = mKeshiView;
        mLoginModule = new MenuDeptListModel();
    }

    public void getHosDepartmentList(Long hospitalId, Long doctorId){
        mLoginModule.getHosDepartmentList(hospitalId, doctorId)
                .subscribe(new ProgressDialogObserver<ResponseBody<List<MenuDepartmentList>>>() {
                    @Override
                    public void onNext(ResponseBody<List<MenuDepartmentList>> listResponseBody) {

                        if (listResponseBody.getCode() != 200){
                            mKeshiView.error(listResponseBody.getMsg());
                            return;
                        }
                        mKeshiView.showKeshiList(listResponseBody);

                    }

                    @Override
                    protected Context attachContext() {
                        return mKeshiView.injectContext();
                    }
                });

    }
}
