package com.byh.module.verlogin.present;

import android.content.Context;
import android.util.Log;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IPersonInfosView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.module.IUserModule;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.present.IPersonInfoPresenter;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.view.IPersonInfoView;
import com.kangxin.common.widget.RxProgressObserver;

import org.greenrobot.eventbus.EventBus;

import java.util.List;
import java.util.Map;

@Route(path = VerloginRouter.PRESENTER_PERSON_INFO)
public class PersonInfoPresent implements IPersonInfoPresenter {
    private VerLoginModule mLoginModule;
    protected IPersonInfoView mPersonView;
    private IUserModule mUserModule;

    public PersonInfoPresent(IPersonInfoView personInfoView) {
        mPersonView = personInfoView;
        mLoginModule = new VerLoginModule();
        mUserModule = new UserModule();
    }

    public PersonInfoPresent() {

    }

    @Override
    public void attachView(IPersonInfoView personInfoView) {
        mPersonView = personInfoView;
        mLoginModule = new VerLoginModule();
        mUserModule = new UserModule();
    }

    /**
     * 获取医生职业
     */
    @Override
    public void occupationList() {
        mLoginModule.getOccupation().subscribe(new RxProgressObserver<ResponseBody<List<OccupationEntity>>>() {
            @Override
            public void onReqNext(ResponseBody<List<OccupationEntity>> listResponseBody) {
                if (mPersonView instanceof IPersonInfosView) {
                    ((IPersonInfosView) mPersonView).occupationSuccess(listResponseBody.getData());
                }
            }
        });
    }

    /**
     * 获取医生职称
     *
     * @param typeCode
     */
    @Override
    public void jobTitleList(String typeCode) {
        mLoginModule.getJobTitle(typeCode).subscribe(new RxProgressObserver<ResponseBody<List<JobTitleEntity>>>() {
            @Override
            public void onReqNext(ResponseBody<List<JobTitleEntity>> listResponseBody) {
                if (mPersonView instanceof IPersonInfosView) {
                    ((IPersonInfosView) mPersonView).jobTitleSuccess(listResponseBody.getData());
                }
            }
        });
    }


    /**
     * 设置卡号职务
     */
    @Override
    public void setSiguUP(Map<String, String> post) {
        mLoginModule.setSiguUP(post).subscribe(new RxProgressObserver<ResponseBody>() {
            @Override
            public void onReqNext(ResponseBody listResponseBody) {
                mPersonView.onSucress(listResponseBody.getMsg());
            }
        });
    }


    /**
     * @param context
     * @param personInfoBody {
     *                       "accountId": "1564315641231",
     *                       "channelCode": "DOCTOR_ANDROID",
     *                       "credTypeCode": "01",
     *                       "displayName": "张三",
     *                       "hospitalDeptId": 12154,
     *                       "hospitalDeptName": "123456",
     *                       "hospitalId": "SRSRMYY",
     *                       "idCardNo": "510000199001200025",
     *                       "phone": "18888888888",
     *                       "profession": "副主任医师",
     *                       "professionCode": "121545",
     *                       "regHospitalName": "上饶市人民医院",
     *                       "speciality": "耳鼻喉",
     *                       "stdFristDeptId": 12154,
     *                       "stdFristDeptName": "12154",
     *                       "stdSecondDeptId": 12154,
     *                       "stdSecondDeptName": "12154"
     *                       }
     */
    @Override
    public void savePersonInfo(Context context, PersonInfoBody personInfoBody) {
        String token = VertifyDataUtil.getInstance(context).getLoginData().getToken();

        mLoginModule.savePersonInfo(token, personInfoBody)
                .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        LoginSuccess loginSuccess = loginSuccessResponseBody.getResult();
                        VertifyDataUtil.getInstance(context).setAccountStatus(loginSuccess.getAccountStatus());
                        if (null != loginSuccessResponseBody.getData().getDoctorLoginInfo()) {
                            doctorzraddInfo(context, loginSuccessResponseBody.getData().getDoctorLoginInfo().getDoctorId(),
                                    loginSuccessResponseBody.getData().getDoctorLoginInfo().getOrganId());
                        }
                        mPersonView.showPersonInfo(loginSuccessResponseBody.getResult());
                    }
                });
    }


    public void doctorzraddInfo(Context context, String doctorId, String organId) {
        mLoginModule.doctorAddInfoCheck(doctorId, organId)
                .subscribe(new RxProgressObserver<ResponseBody>() {
                    @Override
                    public void onReqNext(ResponseBody loginSuccessResponseBody) {
                        VertifyDataUtil.getInstance(context).setInfoCheck((Boolean) loginSuccessResponseBody.getData());
                        EventBus.getDefault().post(new Event.infoCheck((Boolean) loginSuccessResponseBody.getData()));
                        Log.e("Event.infoCheck---6", loginSuccessResponseBody.getData() + "");

                    }
                });
    }

    /**
     * 更新个人信息
     *
     * @param personInfoBody
     */

    @Override
    @Deprecated
    public void updatePersonInfo(Context context, PersonInfoBody personInfoBody) {

    }

    /**
     * 完善资质
     *
     * @param context
     * @param reqWebBody {
     *                   "accountId": "1564315641231",
     *                   "badgeUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "headImageUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardBack": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardFront": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg"
     *                   }
     */
    public void saveCertifyInfo(Context context, ReqWebBody reqWebBody) {
        String token = VertifyDataUtil.getInstance(context).getLoginData().getToken();
        mLoginModule.saveCertifyInfo(token, reqWebBody)
                .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        LoginSuccess loginSuccess = loginSuccessResponseBody.getResult();
                        VertifyDataUtil.getInstance(context).setAccountStatus(loginSuccess.getAccountStatus());
                        if (null != loginSuccess.getDoctorLoginInfo()) {
                            doctorzraddInfo(context, loginSuccess.getDoctorLoginInfo().getDoctorId(),
                                    loginSuccess.getDoctorLoginInfo().getOrganId());
                        }
                        mPersonView.showPersonInfo(loginSuccessResponseBody.getResult());
                    }
                });
    }

    /**
     * 更新个人资质信息
     *
     * @param reqWebBody {
     *                   "accountId": 0,
     *                   "badgeUrl": "string",
     *                   "headImageUrl": "string",
     *                   "idCardBack": "string",
     *                   "idCardFront": "string"
     *                   }
     */
    @Override
    public void updateCertified(Context context, ReqWebBody reqWebBody) {

        String token = VertifyDataUtil.getInstance(context).getLoginData().getToken();
        mLoginModule.updateCertified(token, reqWebBody)
                .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        mPersonView.showPersonInfo(loginSuccessResponseBody.getResult());
                    }
                });
    }

    @Override
    public void init(Context context) {

    }
}
