package com.byh.module.verlogin;

import android.content.Intent;
import android.text.Editable;
import android.text.InputType;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;

import com.byh.module.verlogin.module.ChangePhoneViewModel;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.util.VertifyDataUtil;

public class ChangePhoneByPwdActivity extends BaseActivity {

  private ImageView mPwdShowImg;
  private EditText mVerPwdEdt;
  private TextView tv_next;
  private ChangePhoneViewModel viewModel;

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_change_phone_pwd;
  }

  @Override
  public boolean initYm() {
    return false;
  }

  @Override
  public void start() {

    mPwdShowImg = findViewById(R.id.img_pwd_kejian);
    mVerPwdEdt = findViewById(R.id.et_pwd);
    tv_next = findViewById(R.id.code_next);

    tv_next.setClickable(false);
    tv_next.setEnabled(false);

    viewModel = new ViewModelProvider(this).get(ChangePhoneViewModel.class);

    findViewById(R.id.vLeftImage).setOnClickListener(v->{
      finish();
    });

    final int type = InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_PASSWORD;
    mPwdShowImg.setOnClickListener(view -> {
      if (mVerPwdEdt.getInputType() == type) {
        mVerPwdEdt.setInputType(InputType.TYPE_TEXT_VARIATION_VISIBLE_PASSWORD);
        mVerPwdEdt.setSelection(mVerPwdEdt.getText().length()); //把光标设置到当前文本末尾
        mPwdShowImg.setImageResource(R.drawable.ic_ver_kejian);
      } else {
        mVerPwdEdt.setInputType(type);
        mVerPwdEdt.setSelection(mVerPwdEdt.getText().length());
        mPwdShowImg.setImageResource(R.drawable.ic_bukejian);
      }
    });

    mVerPwdEdt.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {}

      @Override
      public void afterTextChanged(Editable editable) {
        if (editable.length() != 0) {
          mPwdShowImg.setVisibility(View.VISIBLE);

          tv_next.setClickable(true);
          tv_next.setEnabled(true);
          tv_next.setTextColor(getResources().getColor(R.color.white));
          tv_next.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.vercode_order_bg, null));
        } else {
          mPwdShowImg.setVisibility(View.GONE);

          tv_next.setClickable(false);
          tv_next.setEnabled(false);
          tv_next.setTextColor(getResources().getColor(R.color.color_999999));
          tv_next.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.bt_gray_order_bg, null));
        }
      }
    });

    tv_next.setOnClickListener(v->{
      if(TextUtils.isEmpty(mVerPwdEdt.getText().toString().trim())){
        return;
      }
      checkPwd();
    });
  }

  private void checkPwd(){
    String accountNo = VertifyDataUtil.getInstance(ChangePhoneByPwdActivity.this).getAccountNo();
    viewModel.checkPwdForNewPhone(accountNo,mVerPwdEdt.getText().toString().trim()).observe(this, new Observer<ResponseBody>() {
      @Override
      public void onChanged(ResponseBody responseBody) {

        startActivity(new Intent(ChangePhoneByPwdActivity.this,ChangePhoneNewNumActivity.class));
      }
    });
  }
}
