package com.byh.module.verlogin;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.fragment.KeshiNameFragment;
import com.byh.module.verlogin.fragment.SelZhicFragment;
import com.byh.module.verlogin.fragment.SetHosNameFragment;
import com.byh.module.verlogin.fragment.ShanChlyFragment;
import com.byh.module.verlogin.fragment.YiyuanNameFragment;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.base.kt.IToolView;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.doctor.libdata.http.api.Api;

import org.greenrobot.eventbus.EventBus;

import static com.kangxin.doctor.libdata.http.api.Api.HOSPITAL_ID;
import static com.kangxin.doctor.libdata.http.api.Api.HOS_APP_CODE;


@Route(path = VerloginRouter.ACTIVITY_FRAME_PER_INFO_CONTRO)
public class FramePerInfoControActivity extends BaseActivity implements IToolView {

    private static final String TAG = "FramePerInfoControActiv";
    @Override
    public void start() {
        int jumpType = getIntent().getIntExtra(Api.MSG_JUMP_TYPE, -1);

        switch (jumpType){
            case Api.JUMP_YIYUAN_NAME:
                vToolTitleTextView.setText(R.string.yiyuan_name);
                loadRootFragment(R.id.frame_content, new YiyuanNameFragment());
                break;
            case Api.JUMP_KESHI_NAME:
                vToolTitleTextView.setText(R.string.keshi_name);
                long hosId = getIntent().getLongExtra(HOSPITAL_ID, -1L);

                String appCode = getIntent().getStringExtra(HOS_APP_CODE);
                Bundle hosBundle = new Bundle();
                hosBundle.putLong(HOSPITAL_ID, hosId);
                hosBundle.putString(HOS_APP_CODE, appCode);
                Log.i(TAG, TAG + "hosId==>" + hosId);
                KeshiNameFragment keshiNameFragment = KeshiNameFragment.getInstance();
                keshiNameFragment.setArguments(hosBundle);
                loadRootFragment(R.id.frame_content, keshiNameFragment);
                break;
            case Api.JUMP_ZHICH_NAME:
                vToolTitleTextView.setText(R.string.sel_zhic);
                vToolRightTextView.setText(R.string.person_save);
                vToolRightTextView.setVisibility(View.VISIBLE);
                vToolRightTextView.setTextColor(Color.WHITE);
                final SelZhicFragment selZhicFragment = SelZhicFragment.getInstance();
                loadRootFragment(R.id.frame_content, selZhicFragment);

                vToolRightTextView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        SelZhicEntity dicEntity = selZhicFragment.getDictEntity();
                        if (dicEntity != null){
                            EventBus.getDefault().post(dicEntity);
                            finish();
                        }else {
                            ToastUtils.showShort(StringsUtils.getString(R.string.verlogin_fashengyichang_qingzhongshi));
                        }
                    }
                });

                break;
            case Api.JUMP_SHANCLY_NAME:
                vToolTitleTextView.setText(R.string.shanc_liny);

                final ShanChlyFragment shanChlyFragment = new ShanChlyFragment();

                loadRootFragment(R.id.frame_content, shanChlyFragment);
                break;
        }
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.title_frame_layout;
    }

    @Override
    public View getVToolView() {
        return rootView.findViewById(R.id.vToolBar);
    }

    @Override
    public void finishCurrentView() {
        if (getTopFragment() instanceof SetHosNameFragment){
            pop();
        }else {
            HideKeyboard(rootView);
            finish();
        }
    }

    public static void HideKeyboard(View v) {
        InputMethodManager imm = (InputMethodManager) v.getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        if (imm.isActive()) {
            imm.hideSoftInputFromWindow(v.getApplicationWindowToken(), 0);
        }
    }

  @Override
  public boolean initYm() {
    return false;
  }
}
