package com.byh.module.verlogin;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.alibaba.android.arouter.launcher.ARouter;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.callback.LoginPushCallBack;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.event.vertify.WeChatStatusManager;
import com.byh.module.verlogin.present.LoginByVercodePresent;
import com.byh.module.verlogin.present.VerLoginPresent;
import com.byh.module.verlogin.present.WeixAuthPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.ILoginByCodeOkView;
import com.byh.module.verlogin.view.ILoginView;
import com.byh.module.verlogin.view.IWeixAuthView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.ByConfiguration;
import com.kangxin.common.byh.ByPlatform;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.DispatchVerStatus;
import com.kangxin.common.byh.global.router.AppRouter;
import com.kangxin.common.byh.global.router.ByhimRouter;
import com.kangxin.common.byh.global.router.PushAdRouter;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.present.IUpdatePresenter;
import com.kangxin.common.byh.present.impl.UpdatePresenter;
import com.kangxin.common.byh.provider.IPushAdProvider;
import com.kangxin.common.byh.service.IWeixLoginProvider;
import com.kangxin.common.byh.service.ImChatSerivice;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.byh.widget.UserAgrrPrimary;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.push.config.Config;
import com.kangxin.util.common.DeviceIdUtil;
import com.kangxin.util.common.SPUtils;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.widget.common.byh.ZpPhoneEditText;

import org.greenrobot.eventbus.EventBus;

import com.kangxin.push.PushManager;

import static com.kangxin.common.byh.global.Global.WEIX_LOGIN_ACTION;
import static com.kangxin.common.byh.global.Global.WEIX_RESP_ACTION;
import static com.kangxin.common.byh.global.Global.WEIX_RESP_CODE_KEY;

/**
 * 登录页面
 */
@Route(path = VerloginRouter.LOGIN)
public class LoginActivity extends BaseActivity implements ILoginView, ILoginByCodeOkView, IWeixAuthView {

  private static final String TAG = "LoginActivity";
  ZpPhoneEditText mPhoneNumEdit;
  ImageView mClosePhoneNumImg;
  TextView mVercodeText;

  Button mLoginButton;
  EditText mVercodeEdt;
  ImageView mBackImg;
  TextView mErrNoticeText;

  private CountDownUtil mCountDownUtil;
  private VerLoginPresent mLoginPresent;
  private LoginByVercodePresent mLoginByVercodePresent;

  private WeixRespReceiver mWeixRespReceiver;
  private WeixAuthPresent mWeixAuthPresent;

  private IUpdatePresenter updatePresenter = new UpdatePresenter();

  private CheckBox mCheckBox;

  @Override
  public void authOk(LoginSuccess loginSuccess) {
    updateUserInfo();
    receiveStatus(loginSuccess.getAccountStatus(), LoginFlag.WECHAT);
  }

  @Override
  public boolean initYm() {
    return false;
  }

  private class WeixRespReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
      String code = intent.getStringExtra(WEIX_RESP_CODE_KEY);
      Log.i(TAG, "code===>" + code);
      mWeixAuthPresent = new WeixAuthPresent(getBaseContext(),
        LoginActivity.this);
      mWeixAuthPresent.reqWeixAuth(code);
    }
  }

  private void registerWeixRespReceiver() {
    mWeixRespReceiver = new WeixRespReceiver();
    IntentFilter intentFilter = new IntentFilter(WEIX_RESP_ACTION);
    registerReceiver(mWeixRespReceiver, intentFilter);
  }


  private void unRegisterWeixRespReceiver() {
    if (mWeixRespReceiver == null) {
      return;
    }

    unregisterReceiver(mWeixRespReceiver);
    if (mWeixLoginProvider != null) {
      mWeixLoginProvider.unRegisterWeixBroadCast();
    }
  }

  private IWeixLoginProvider mWeixLoginProvider = (IWeixLoginProvider) ARouter.getInstance().build(AppRouter.WEIXIN_LOGIN_PROVIDER).navigation();

  @Override
  public void start() {

    TextView login_question = findViewById(R.id.login_question);
    if (login_question != null) {
      login_question.setOnClickListener(new View.OnClickListener() {
        @Override
        public void onClick(View v) {
          ARouter.getInstance().build(AppRouter.CONTACT_US_URL).navigation();
        }
      });
    }


    mLoginPresent = new VerLoginPresent(this);
    mLoginByVercodePresent = new LoginByVercodePresent(this);
    initViews();

    findViewById(R.id.weix_login_btn).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
          if (mWeixLoginProvider != null) {
            mWeixLoginProvider.registerWeixBroadCast(WEIX_LOGIN_ACTION);
            mWeixLoginProvider.sendWeixLoginBroadCast(WEIX_LOGIN_ACTION);
          }
        } else {
          Intent intent = new Intent(WEIX_LOGIN_ACTION);
          sendBroadcast(intent);
        }
      }
    });

    registerWeixRespReceiver();

//        UpdateManager
//                .create(this)
//                .setUrl(SwitchUrlUtil.INSTANCE.getInitBaseUrl() + CHECK_UPDATE)
//                .setPrompter(new RocketUpdatePrompter(this))
//                .setChecker((agent, url) -> updatePresenter.checkUpdate(agent, AppUtils.getAppVersionCode()))
//                .setParser(source -> new Gson().fromJson(source, UpdateInfo.class))
//                .check();

    findViewById(R.id.weix_login_btn).setVisibility(ByPlatform.createResources()
      .addBy(View.VISIBLE)
      .addYd(View.VISIBLE)
      .addHt(View.VISIBLE)
      .addNde(View.GONE)
      .addZdy(View.GONE)
      .addLyt(View.VISIBLE)
      .addYc(View.GONE)
      .intValue());
  }

  private void initViews() {
    mCheckBox = findViewById(R.id.mCheckBox);
    findViewById(R.id.ver_user_xieyi).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        //TODO 用户协议...
        Bundle bundle = new Bundle();
        bundle.putString("loadurl", ByConfiguration.getUserAgreement(ByConfiguration.getPlatformCode()));
        bundle.putString("title", getResources().getString(R.string.user_agreement));
        Intent intent = new Intent(LoginActivity.this, AgreementNoticeCountryActivity.class);
        intent.putExtras(bundle);
        startActivity(intent);
      }
    });

    findViewById(R.id.ver_yinsizhc).setOnClickListener(new View.OnClickListener() {
      @Override
      public void onClick(View v) {
        //TODO 隐私协议...
        Bundle bundle = new Bundle();
        bundle.putString("loadurl", ByConfiguration.getPrivatePolicy(ByConfiguration.getPlatformCode()));
        bundle.putString("title", getResources().getString(R.string.legal_notice));
        Intent intent = new Intent(LoginActivity.this, AgreementNoticeCountryActivity.class);
        intent.putExtras(bundle);
        startActivity(intent);
      }
    });


    mPhoneNumEdit = findViewById(R.id.edt_phonenum);


    mClosePhoneNumImg = findViewById(R.id.clearlogin_img);
    mVercodeText = findViewById(R.id.vercode_txt);
    mLoginButton = findViewById(R.id.bt_login);
    mVercodeEdt = findViewById(R.id.edt_vercode);
    mBackImg = findViewById(R.id.img_back_ver);
    mErrNoticeText = findViewById(R.id.err_notice);

    mLoginButton.setClickable(false);
    mCountDownUtil = new CountDownUtil(mVercodeText)
      .setCountDownMillis(60_000L)
      .setCountDownColor(R.color.white, android.R.color.darker_gray);//倒计时60000ms

    isVercodeUsable(false);

    mCountDownUtil.setOnDownEndListener(() -> {
      String phoneNum = mPhoneNumEdit.getPhoneText();
      if (!TextUtils.isEmpty(phoneNum)) {
        isVercodeUsable(true);
      } else {
        isVercodeUsable(false);
      }

    });

    mClosePhoneNumImg.setOnClickListener(view -> mPhoneNumEdit.setText(""));


    //发送验证码
    mVercodeText.setOnClickListener(view -> {
      String phoneNum = mPhoneNumEdit.getPhoneText();
      if (TextUtils.isEmpty(phoneNum)) {
        return;
      }

      mLoginPresent.sentVerCode(phoneNum);
      isVercodeUsable(false);
    });

    addEdtChangeListener();
    //用户协议和隐私政策对话框
    UserAgrrPrimary.getInstance().showAgreenDialog(this, new UserAgrrPrimary.OnRxReq() {
      @Override
      public void onNext() {

        //用户点击隐私协议同意按钮后，初始化PushSDK
        PushManager.getInstance().initPush(
          new Config(LoginActivity.this.getApplicationContext())
            .appKey(ByConfiguration.getUMAppKey())
            .messageSecret(ByConfiguration.getUMAppSecret()));

        PushManager.getInstance().registerPushCallback(new LoginPushCallBack());

        //融云IM
        ImChatSerivice chatSerivice = (ImChatSerivice) ARouter.getInstance().build(ByhimRouter.IM_CHAT_SERVICE).navigation();
        if (chatSerivice != null) {
          chatSerivice.initRongIm();
        }

        //保存
        SPUtils.setSharedBooleanData(LoginActivity.this.getApplicationContext(),"privacy_agreement",true);

      }
    });
    IPushAdProvider pushAdProvider = (IPushAdProvider) ARouter.getInstance().build(PushAdRouter.REQUEST_PATH).navigation();
    if (pushAdProvider != null) {
      pushAdProvider.request();
    }
  }

  private void addEdtChangeListener() {
    mPhoneNumEdit.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void afterTextChanged(Editable editable) {
        mErrNoticeText.setVisibility(View.GONE);

        if (editable.length() != 0) {
          mClosePhoneNumImg.setVisibility(View.VISIBLE);

          mBackImg.setImageResource(R.drawable.ic_gray_fanhui);
        } else {
          mClosePhoneNumImg.setVisibility(View.GONE);
          mBackImg.setImageResource(R.drawable.ic_ver_guanbi);

        }

        String phoneNum = mPhoneNumEdit.getPhoneText();
        if (VerifyUtil.isMobilePhoneNumber(phoneNum)) {
          isVercodeUsable(true);
        } else {
          isVercodeUsable(false);
        }

      }
    });


    mVercodeEdt.addTextChangedListener(new TextWatcher() {
      @Override
      public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @Override
      public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {

      }

      @RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN)
      @Override
      public void afterTextChanged(Editable editable) {
        mErrNoticeText.setVisibility(View.GONE);
        if (editable.length() == 6) {
          mLoginButton.setClickable(true);
          mLoginButton.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.vercode_order_bg, null));
        } else {
          mLoginButton.setClickable(false);
          mLoginButton.setBackground(ResourcesCompat.getDrawable(getResources(),
            R.drawable.bt_gray_order_bg, null));
        }

        if (editable.length() != 0) {
          mBackImg.setImageResource(R.drawable.ic_gray_fanhui);
        } else {
          mBackImg.setImageResource(R.drawable.ic_ver_guanbi);

        }
      }
    });
  }

  @Override
  public int getContentLayoutId() {
    return R.layout.activity_ver_login;
  }


  /**
   * 点击登录按钮
   *
   * @param view
   */
  public void clickLogin(View view) {
    if (!mCheckBox.isChecked()) {
      ToastUtils.showShort("请勾选隐私政策以及用户协议");
      return;
    }
    String phoneNum = mPhoneNumEdit.getPhoneText();
    String verCode = mVercodeEdt.getText().toString().trim();

    if (!VerifyUtil.isMobilePhoneNumber(phoneNum)) {
//            mErrNoticeText.setText(StringsUtils.getString(R.string.verlogin_shoujihaogeshibuzhengque));
      ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_shoujihaogeshibuzhengque));
      return;
    }

    Login login = new Login();

    login.setAccountNo(phoneNum);

    String authKey = mLoginPresent.getAuthKey();
    if (TextUtils.isEmpty(authKey)) {
      ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_qinghuoquyanzhengma));
      return;
    }

    login.setAuthKey(authKey);
    login.setCode(verCode);

    login.setLoginDeviceNum(PushManager.getDeviceId(mContext, DeviceIdUtil.getDeviceId(mContext)));
    mLoginByVercodePresent.loginByVercode(getBaseContext(), login);

//
//        DispatchVerStatus loginDispatchStatus = new LoginDispatchStatus();
//        loginDispatchStatus.registerStatus(new LoginStatusManager(this));
//
//        loginDispatchStatus.dispatchStatus(0);

  }

  public void clickPwdLogin(View view) {
    startActivity(new Intent(this, PwdLoginActivity.class));
  }

  public void clickBack(View view) {

    String phoneNum = mPhoneNumEdit.getPhoneText();
    String verCode = mVercodeEdt.getText().toString().trim();

    if (!TextUtils.isEmpty(phoneNum) || !TextUtils.isEmpty(verCode)) {
      mPhoneNumEdit.setText("");
      mVercodeEdt.setText("");
      mCountDownUtil.reset();
      isVercodeUsable(false);
    } else {
      ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
      finish();
    }

  }

  @Override
  public void onBackPressedSupport() {
    ARouter.getInstance().build(AppRouter.MAIN_PAGE_URL).navigation();
    finish();
  }

  @Override
  public void loginOk(ResponseBody<LoginSuccess> loginSuccess) {

  }

  @Override
  public void reqErr(String err) {
    Log.i(TAG, "==reqErr==" + err);
    mCountDownUtil.reset();
//        mErrNoticeText.setVisibility(View.VISIBLE);
//        mErrNoticeText.setText(err);
  }

  @Override
  public void receiveVercode() {
    mCountDownUtil.start();
//    Log.i(TAG, "==verCode==" + verCode);
//    if (verCode == null) {
//      return;
//    }
//
//    mVerCode = verCode.getVerifyCode();
//    mVerCodeEntity = verCode;
  }

  private String mVerCode;
  private VerCodeEntity mVerCodeEntity;


  @Override
  public void setPwdOk(String msg) {

  }

  @Override
  public void getCheck() {
  }

  @Override
  public void getCheck(int stutas) {

  }

  /**
   * 验证码状态改变
   * @param isUse
   */
  private void isVercodeUsable(boolean isUse) {
    if (isUse) {
      mCountDownUtil.setUsable(true);
      mVercodeText.setBackground(ResourcesCompat.getDrawable(getResources(),
        R.drawable.vercode_order_bg, null));
      mVercodeText.setTextColor(getResources().getColor(android.R.color.white));
      mVercodeText.setClickable(true);
      mVercodeText.setFocusable(true);
      mVercodeText.setText(R.string.ver_getvercode);
    } else {
      mCountDownUtil.setUsable(false);
      mVercodeText.setBackground(ResourcesCompat.getDrawable(getResources(),
        R.drawable.edt_order_bg, null));
      mVercodeText.setTextColor(getResources().getColor(android.R.color.darker_gray));
      mVercodeText.setText(R.string.ver_getvercode);
      mVercodeText.setClickable(false);
      mVercodeText.setFocusable(false);
    }
  }

  @Override
  public void loginByCodeOk(LoginSuccess loginSuccess, String msg) {
    Log.i(TAG, "loginByCodeOk==>" + loginSuccess);

    if (loginSuccess == null) {
      showShortToast(msg);
      return;
    }

    updateUserInfo();

    receiveStatus(loginSuccess.getAccountStatus(), LoginFlag.NORMAL);
  }

  private void updateUserInfo() {

    UpdateVerStatus.getInstance().updateDocDetailInfo(getBaseContext(),
      new IUpdateVerStatus.OnUpdateDocDetailInfoCallback() {
        @Override
        public void updateDocDetailInfoOk() {
        }

        @Override
        public void updateDocDetailInfoErr(String err) {
          showShortToast(err);

        }
      });
  }

  /**
   * 登录方式
   */
  enum LoginFlag {
    /**
     * 微信登录
     */
    WECHAT,
    /**
     * 普通登录
     */
    NORMAL
  }

  public void receiveStatus(int status, LoginFlag loginFlag) {

    Log.i(TAG, "===receiveStatus==");
    DispatchVerStatus loginDispatchStatus = new LoginDispatchStatus();
    if (loginFlag == LoginFlag.WECHAT) {
      loginDispatchStatus.registerStatus(new WeChatStatusManager(this));
    } else {
      loginDispatchStatus.registerStatus(new LoginStatusManager(this));
    }

    loginDispatchStatus.dispatchStatus(status);
    EventBus.getDefault().post(new ByhCommEvent.LoginOkEvent());

    UpdateVerStatus.getInstance().updateImToken(getBaseContext());
    finish();
    IPushAdProvider pushAdProvider = (IPushAdProvider) ARouter.getInstance().build(PushAdRouter.REQUEST_PATH).navigation();
    if (pushAdProvider != null) {
      pushAdProvider.request();
    }
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();
    unRegisterWeixRespReceiver();
  }
}
