package com.byh.module.verlogin;

import android.app.AlertDialog;
import android.content.Intent;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;

import com.byh.module.verlogin.present.ForgetResetLoginPresent;
import com.byh.module.verlogin.view.IForgetPwdView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.AppManager;


public class ResetPasswordActivity extends BaseActivity implements IForgetPwdView {

    private EditText                mResetPwdEt;
    private String                  mPhoneNum;
    private ForgetResetLoginPresent mForgetResetLoginPresent;

    @Override
    public void start() {
        mForgetResetLoginPresent = new ForgetResetLoginPresent(this);
        mPhoneNum = getIntent().getStringExtra("phoneNum");
        initViews();
    }

    private void initViews() {
        mResetPwdEt  = findViewById(R.id.edit_reset_pwd);

        // 如下是内容为空的配置，需要两个属性结合使用；如果有默认值，进行相反的配置
        // 设置文字的对齐方式
        mResetPwdEt.setGravity(Gravity.END | Gravity.CENTER_VERTICAL);
        // 设置文本的显示方向
        mResetPwdEt.setTextDirection(View.TEXT_DIRECTION_LTR);
        mResetPwdEt.setFocusableInTouchMode(true);
        mResetPwdEt.setFocusable(true);
        mResetPwdEt.setSelection(mResetPwdEt.getText().length());

        findViewById(R.id.vLeftImage).setOnClickListener(v -> finish());

        addEdtChangeListener();
    }

    private void addEdtChangeListener() {
        mResetPwdEt.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @Override
            public void afterTextChanged(Editable editable) {
                if (TextUtils.isEmpty(editable.toString())) {
                    mResetPwdEt.setGravity(Gravity.START | Gravity.CENTER_VERTICAL);
                    mResetPwdEt.setSelection(mResetPwdEt.getText().length());
                    mResetPwdEt.setTextDirection(View.TEXT_DIRECTION_RTL);
                } else {
                    mResetPwdEt.setGravity(Gravity.END | Gravity.CENTER_VERTICAL);
                    mResetPwdEt.setSelection(mResetPwdEt.getText().length());
                    mResetPwdEt.setTextDirection(View.TEXT_DIRECTION_LTR);
                }
            }
        });
    }

    @Override
    public int getContentLayoutId() {
        return R.layout.activity_reset_password;
    }

    /**
     * 点击下一步
     * @param view
     */
    public void onNextStepClick(View view) {
        String pwd = mResetPwdEt.getText().toString().trim();
        if (!VertifyDataUtil.getInstance(getBaseContext()).authPwd(pwd)){
            return;
        }

        if (VertifyDataUtil.getInstance(getBaseContext()).authPwd(pwd)){
            mForgetResetLoginPresent.resetLoginPwd(mPhoneNum,
                    mResetPwdEt.getText().toString().trim());
        }
    }


    @Override
    public void setPwdOk(String code) {
        if (code.equals("200")) {
            //创建一个AlertDialog对话框
            AlertDialog alertDialog = new AlertDialog.Builder(this).create();
            alertDialog.setCancelable(false);
            //显示
            alertDialog.show();
            Window window = alertDialog.getWindow();
            //对话框中显示的哪一个布局
            window.setContentView(R.layout.dialog_resetpwded_layout);
            WindowManager.LayoutParams params = window.getAttributes();
            Display display = getWindowManager().getDefaultDisplay();  //为获取屏幕宽、高
            params.height = (int) (display.getHeight() * 0.25);   //高度设置为屏幕的0.2
            params.width  = (int) (display.getWidth() * 0.7);    //宽度设置为屏幕的0.7
            alertDialog.getWindow().setAttributes(params);
            alertDialog.getWindow().setBackgroundDrawableResource(R.drawable.search_order_bg);

            window.findViewById(R.id.ok_click_layout).setOnClickListener(v -> {
                alertDialog.dismiss();
                AppManager.getAppManager().finishActivity(PwdLoginActivity.class);
                startActivity(new Intent(getMContext(), PwdLoginActivity.class));
                finish();
                AppManager.getAppManager().finishActivity(ForgetPassWordActivity.class);
            });
        } else {
            showShortToast(getResources().getString(R.string.reset_pwd_failed));
        }
    }

  @Override
  public boolean initYm() {
    return false;
  }
}
