package com.byh.module.verlogin.api;

import com.byh.module.verlogin.entity.AllRegionEntity;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.LogoutAccountReqEntity;
import com.byh.module.verlogin.entity.LogoutBody;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.entity.PwdParam;
import com.byh.module.verlogin.entity.UpdatePhoneParam;
import com.byh.module.verlogin.entity.UserDevInfoEntity;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.entity.VertifyStatus;
import com.byh.module.verlogin.entity.WeixRespTokenEntity;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.VerHospitalListEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.req.SmsAuthReq;
import com.kangxin.common.byh.entity.req.SmsSendAuthCodeReq;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.global.Global;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.POST;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;

import static com.kangxin.common.byh.global.Global.ACCOUNT_LOGIN;
import static com.kangxin.common.byh.global.Global.ACCOUNT_LOGIN_OUT_APP;
import static com.kangxin.common.byh.global.Global.ADD_DEPT_URL;
import static com.kangxin.common.byh.global.Global.ADD_HOSPITALINFO;
import static com.kangxin.common.byh.global.Global.AUTH_PATH;
import static com.kangxin.common.byh.global.Global.BINDWEIX_REQ;
import static com.kangxin.common.byh.global.Global.JOB_TITLE_URL;
import static com.kangxin.common.byh.global.Global.LOGIN_BY_VERCODE;
import static com.kangxin.common.byh.global.Global.LOGIN_OUT_APP;
import static com.kangxin.common.byh.global.Global.OCCUPATION_URL;
import static com.kangxin.common.byh.global.Global.PROSS_LIST_URL;
import static com.kangxin.common.byh.global.Global.REQ_PROVINCE_CITY_AREA;
import static com.kangxin.common.byh.global.Global.RESET_LOGIN_PWD;
import static com.kangxin.common.byh.global.Global.SAVE_CERTIFYINFO;
import static com.kangxin.common.byh.global.Global.SAVE_USERINFO;
import static com.kangxin.common.byh.global.Global.SEND_SMS2_CODE;
import static com.kangxin.common.byh.global.Global.SEND_SMS_CODE;
import static com.kangxin.common.byh.global.Global.SETPWD_URL;
import static com.kangxin.common.byh.global.Global.UNIONID_REQ;
import static com.kangxin.common.byh.global.Global.UPDATE_CERTIFYINFO;
import static com.kangxin.common.byh.global.Global.UPDATE_PWD;
import static com.kangxin.common.byh.global.Global.UPDATE_USERDEV_INFO;
import static com.kangxin.common.byh.global.Global.WECHAT_LOGIN;

public interface VerLoginApi {
    /**
     * 登录
     *
     * @param login
     * @return
     */
    @POST(ACCOUNT_LOGIN)
    Observable<ResponseBody<LoginSuccess>> userLogin(@Body Login login);

    /**
     * 资料是否完善——弹窗业务
     *
     * @return
     */
    @GET("cloud/doctorbasedata/doctor/doctorAddInfoCheck")
    Observable<ResponseBody> doctorAddInfoCheck(@Query("doctorId") String doctorId, @Query("organId") String organId);


    /**
     * 微信登录
     *
     * @param login {
     *              "channelCode": "DOCTOR_ANDROID",
     *              "code": "hfuisksd55555648dfd",
     *              "loginDeviceNum": "236511321231441",
     *              "loginDeviceType": "APP"
     *              }
     * @return
     */
    @POST(WECHAT_LOGIN)
    Observable<ResponseBody<LoginSuccess>> loginByWeixin(@Body Login login);

    /**
     * 根据code 请求微信的token
     *
     * @param reqWebBody
     * @return
     */
    @POST(WECHAT_LOGIN)
    Observable<ResponseBody<LoginSuccess>> reqWeixToken(@Body ReqWebBody reqWebBody);

    /**
     * 判断是否绑定微信
     *
     * @param unionId
     * @return
     */
    @POST(UNIONID_REQ)
    Observable<ResponseBody<WeixRespTokenEntity>> resHasBindWeix(@Query("unionId") String unionId);

    /**
     *
     * @param mobileNumber
     * @param openId
     * @param unionId
     * @return
     */

    /**
     * 绑定微信
     *
     * @param reqWebBody {
     *                   "authKey": "authKey",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "code": "123456",
     *                   "loginDeviceNum": "236511321231441",
     *                   "loginDeviceType": "APP",
     *                   "mobileNumber": "18888888888",
     *                   "openId": "123456",
     *                   "unionId": "123456"
     *                   }
     * @return
     */
    @POST(BINDWEIX_REQ)
    Observable<ResponseBody<LoginSuccess>> reqBindWeChat(@Body ReqWebBody reqWebBody);

    @POST("/auth/api/v1/app_doctor/phonenum_login")
    Observable<ResponseBody<VerCodeEntity>> sendVertifyCode(@Query("phoneNum") String mobileNumber);

    @GET("/doctor/api/v1/doctorlogin/getstatus")
    Observable<ResponseBody<VertifyStatus>> getStatus(@Query("phone") String phonenum);

    /**
     * 设置密码
     *
     * @param login
     * @return
     */
    @POST(SETPWD_URL)
    Observable<ResponseBody<LoginSuccess>> setPassword(@Body Login login);

    /**
     * 保存个人信息
     *
     * @param token
     * @param personInfoBody
     * @return
     */
    @POST(SAVE_USERINFO)
    Observable<ResponseBody<LoginSuccess>> savePersonInfo(@Header("token") String token, @Body PersonInfoBody personInfoBody);


    /**
     * 更新认证信息
     * *   "accountId": 0,
     * *   "badgeUrl": "string",
     * *   "headImageUrl": "string",
     * *   "idCardBack": "string",
     * *   "idCardFront": "string"
     * * }
     *
     * @param token
     * @param reqWebBody
     * @return
     */
    @POST(UPDATE_CERTIFYINFO)
    Observable<ResponseBody<LoginSuccess>> updateCertified(@Header("token") String token,
                                                           @Body ReqWebBody reqWebBody);

    /**
     * 完善医生资质
     *
     * @param token
     * @param reqWebBody {
     *                   "accountId": "1564315641231",
     *                   "badgeUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "headImageUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardBack": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardFront": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg"
     *                   }
     * @return
     */
    @POST(SAVE_CERTIFYINFO)
    Observable<ResponseBody<LoginSuccess>> saveCertifyInfo(@Header("token") String token, @Body ReqWebBody reqWebBody);


    /**
     * 获取职称列表
     *
     * @param accessToken
     * @param reqWebBody
     * @return
     */
    @POST(PROSS_LIST_URL)
    Observable<ResponseBody<List<SelZhicEntity>>> findProfessionalList(@Header("accessToken") String accessToken,
                                                                       @Body ReqWebBody reqWebBody);


    @GET("/hospital/api/v1/hospitalinfo/get_doctor_hospital_info")
    Observable<ResponseBody<VerHospitalListEntity>> getVerHospitalList(@Query("doctorId") Long doctorId,
                                                                       @Query("page") Integer page,
                                                                       @Query("size") Integer size,
                                                                       @Query("searchParam") String searchParam,
                                                                       @Query("distCode") String distCode);

    /**
     * 通过验证码登录
     *
     * @param login
     * @return
     */
    @POST(LOGIN_BY_VERCODE)
    Observable<ResponseBody<LoginSuccess>> loginByVercode(@Body Login login);

    /**
     * 发送短信验证码
     *
     * @param smsSendAuthCodeReq {
     *                           "tel": {
     *                           "mobile": "例: 133xxxxxxxx",
     *                           "nationCode": "例: 86，若不传递则默认为中国国家码86"
     *                           },
     *                           "templateCode": "例：向通知服务系统索要"
     *                           }
     * @return
     */
    @POST(SEND_SMS_CODE)
    Observable<ResponseBody<LoginSuccess>> sendSmsAuthCode(@Body SmsSendAuthCodeReq smsSendAuthCodeReq);

    @POST(SEND_SMS2_CODE)
    Observable<ResponseBody<LoginSuccess>> sendSmsAuthCode(@Body SmsAuthReq smsAuthReq);

    /**
     * 重置登录密码
     *
     * @param requestBody {
     *                    "accountNo": "string",
     *                    "channelCode": "DOCTOR_ANDROID",
     *                    "password": "string"
     *                    }
     * @return
     */
    @POST(RESET_LOGIN_PWD)
    Observable<ResponseBody<LoginSuccess>> setForgetResetPwdPersonInfo(@Body ReqWebBody requestBody);

    /**
     * 更新用户设备信息
     *
     * @param userDevInfoEntity
     * @return
     */
    @POST(UPDATE_USERDEV_INFO)
    Observable<ResponseBody> updateUserDeviceInfo(@Body UserDevInfoEntity userDevInfoEntity);

    /**
     * 添加医院
     *
     * @param
     * @return
     */
    @POST(ADD_HOSPITALINFO)
    Observable<ResponseBody> addHospitalInfo(@Query("hospitalName") String hospitalName,
                                             @Query("doctorId") Long doctorId,
                                             @Query("distCode") String distCode);

    /**
     * 添加科室
     *
     * @param departmentName
     * @param stdFirstDepId
     * @param hospitalId
     * @return
     */
    @POST(ADD_DEPT_URL)
    Observable<ResponseBody> addHosDepartment(@Query("departmentName") String departmentName,
                                              @Query("stdFirstDepId") Long stdFirstDepId,
                                              @Query("hospitalId") Long hospitalId,
                                              @Query("doctorId") Long doctorId);

    /**
     * 退出app
     *
     * @param
     * @return
     */
    @POST(LOGIN_OUT_APP)
    Observable<ResponseBody> exitApp(@Body LogoutBody body);

    /**
     * 账号注销
     * @param
     * @return
     */
    @POST(ACCOUNT_LOGIN_OUT_APP)
    Observable<ResponseBody> cancelAppAccount(@Body LogoutAccountReqEntity logoutAccountReqEntity);


    /**
     * 验证短信验证码
     *
     * @param reqWebBody
     * @return
     */
    @POST(Global.VALIDATE_PHONE_AND_CODE)
    Observable<ResponseBody> validatePhoneAndCode(@Body ReqWebBody reqWebBody);

    /**
     * 请求省市区的数据
     *
     * @return
     */
    @GET(REQ_PROVINCE_CITY_AREA)
    Observable<ResponseBody<List<AllRegionEntity>>> reqRegionProvinceCityArea();


    /**
     * 修改密码
     *
     * @param login {
     *              "accountId": "string",
     *              "authKey": "string",
     *              "channelCode": "DOCTOR_ANDROID",
     *              "code": "string",
     *              "password": "string",
     *              "passwordNew": "string",
     *              "type": "1短信校验修改、2原密码校验修改"
     *              }
     * @return
     */
    @POST(UPDATE_PWD)
    Observable<ResponseBody<LoginSuccess>> updatePassword(@Body Login login);

    /**
     * 获取医生职业
     */
    @GET(OCCUPATION_URL)
    Observable<ResponseBody<List<OccupationEntity>>> getOccupation();

    /**
     * 获取医生职称
     */
    @GET(JOB_TITLE_URL)
    Observable<ResponseBody<List<JobTitleEntity>>> getJobTitle(@Query("parentCode") String parentCode);

    /**
     * 查询userSign
     *
     * @param reqWebBody
     * @return
     */
    @GET("/cloud/doctorbasedata/doctor/updateDoctorPostById")
    Observable<ResponseBody> setSiguUP(@QueryMap Map<String, String> reqWebBody);

    //更新手机号
    @POST(AUTH_PATH + "/cloudaccount/updateUserInfo/phone")
    Observable<ResponseBody<Object>> updateNewPhoneNum(@Body UpdatePhoneParam phoneNumber);

    //更新手机号时 校验密码
    @POST(AUTH_PATH + "/cloudaccount/checkLoginPwd")
    Observable<ResponseBody<Object>> checkPwdForNewPhoneNum(@Body PwdParam loginPwd);
}
