package com.byh.module.verlogin.event.vertify;

import com.kangxin.common.byh.event.DispatchVerStatus;
import com.kangxin.common.byh.event.VerStatusManager;

import static com.kangxin.common.byh.global.VertifyStatus.AUTH_AGAIN;
import static com.kangxin.common.byh.global.VertifyStatus.AUTH_FAILED;
import static com.kangxin.common.byh.global.VertifyStatus.AUTH_ING;
import static com.kangxin.common.byh.global.VertifyStatus.DISABELD;
import static com.kangxin.common.byh.global.VertifyStatus.ENABELD;
import static com.kangxin.common.byh.global.VertifyStatus.NO_AUTH_INFO;
import static com.kangxin.common.byh.global.VertifyStatus.NO_EXIT;
import static com.kangxin.common.byh.global.VertifyStatus.NO_PERSON_INFO;
import static com.kangxin.common.byh.global.VertifyStatus.NO_REGISTER;
import static com.kangxin.common.byh.global.VertifyStatus.NO_SET_PWD;
import static com.kangxin.common.byh.global.VertifyStatus.UNUSED;
import static com.kangxin.common.byh.global.VertifyStatus.UN_AUTH;

public class LoginDispatchStatus implements DispatchVerStatus {

  private VerStatusManager verStatusManager;

  @Override
  public void registerStatus(VerStatusManager verStatusManager) {
    this.verStatusManager = verStatusManager;
  }

  @Override
  public void dispatchStatus(int status) {
    if (this.verStatusManager == null) {
      return;
    }

    switch (status) {
      case ENABELD:
        this.verStatusManager.verEnabled();
        break;
      case NO_REGISTER:
        this.verStatusManager.verNoRegister();
        break;
      case NO_PERSON_INFO:
        this.verStatusManager.verNoPersonInfo();
        break;
      case NO_AUTH_INFO:
        this.verStatusManager.verNoAuthInfo();
        break;
      case UN_AUTH:
        this.verStatusManager.verUnAuth();
        break;
      case AUTH_ING:
        this.verStatusManager.verAuthIng();
        break;
      case AUTH_FAILED:
        this.verStatusManager.verAuthFailed();
        break;
      case DISABELD:
        this.verStatusManager.verDisAbled();
        break;
      case UNUSED:
        this.verStatusManager.verUnUsed();
        break;
      case NO_EXIT:
        this.verStatusManager.verNoExit();
        break;
      case AUTH_AGAIN:
        this.verStatusManager.verAuthAgain();
        break;
      case NO_SET_PWD:
        this.verStatusManager.verNoSetPwd();
        break;

    }
  }





}
