package com.byh.module.verlogin.fragment;


import android.os.Build;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.RequiresApi;

import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.R;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.inter.ISupportFragmentObservable;
import com.kangxin.common.byh.service.HosCityListService;


import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import me.yokeyword.fragmentation.ISupportFragment;

import static com.kangxin.common.byh.global.router.WorkTableRouter.HOS_PAGE_SERVICE;

public class YiyuanNameFragment extends BaseFragment {

    private static final String TAG = "YiyuanNameFragment";

    private boolean isShowCityPage = true;

    private String mAreaCode = "";
    private ByhCommEvent.CityEntity mCityEntity;

    @RequiresApi(api = Build.VERSION_CODES.CUPCAKE)
    @Override
    public void init() {

        hideSoftInput();
        initSearchHospital();
        HosCityListService hosCityListService = (HosCityListService) ARouter.getInstance().build(HOS_PAGE_SERVICE).navigation();

        if (hosCityListService != null){

            ISupportFragmentObservable cityFragment = hosCityListService.getCityFragment();



            ISupportFragment hosListFragment = hosCityListService.getHosListFragment("") ;
            loadMultipleRootFragment(R.id.frame_content, 1, cityFragment, hosListFragment);


            TextView cityNameView = findViewById(rootView, R.id.txt_location);

            cityFragment.subscribe((o, arg) -> {
                        mCityEntity = (ByhCommEvent.CityEntity) arg;
                        String cityName = mCityEntity.getCityName();
                        cityNameView.setText(cityName);

                        mAreaCode = mCityEntity.getCode();
                        isShowCityPage = true;
                        showHideFragment(hosListFragment);
                        EventBus.getDefault().post(new ByhCommEvent.UpdateHosListEvent("", mAreaCode));
                    }
            );

            cityNameView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (isShowCityPage){
                        showHideFragment(cityFragment);
                        isShowCityPage = false;
                    }else {
                        showHideFragment(hosListFragment);
                        isShowCityPage = true;
                    }
                }
            });
        }


    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void receiveHosEntityEvent(ByhCommEvent.HosEntityEvent hosEntityEvent){
        getActivity().finish();
    }

    @RequiresApi(api = Build.VERSION_CODES.CUPCAKE)
    private void initSearchHospital() {
        final EditText searchEdt = findViewById(rootView, R.id.search_yiy);
        searchEdt.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_SEARCH) {
                    String searchParam = searchEdt.getText().toString().trim();
                    if (TextUtils.isEmpty(searchParam)){
                        return true;
                    }

                    EventBus.getDefault().post(new ByhCommEvent.UpdateHosListEvent(searchParam, mAreaCode));
                }
                return false;
            }
        });
    }

    @Override
    protected int getLayoutId() {
        return R.layout.yiyuuan_name_fragment;
    }

}
