package com.byh.module.verlogin.module;

import com.byh.module.verlogin.entity.AllRegionEntity;
import com.byh.module.verlogin.entity.JobTitleEntity;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.entity.LogoutAccountReqEntity;
import com.byh.module.verlogin.entity.LogoutBody;
import com.byh.module.verlogin.entity.OccupationEntity;
import com.byh.module.verlogin.entity.PwdParam;
import com.byh.module.verlogin.entity.UpdatePhoneParam;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.byh.module.verlogin.entity.UserDevInfoEntity;
import com.byh.module.verlogin.entity.VerCodeEntity;
import com.byh.module.verlogin.entity.VertifyStatus;
import com.byh.module.verlogin.entity.WeixRespTokenEntity;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.PersonInfoBody;
import com.kangxin.common.byh.entity.SelZhicEntity;
import com.kangxin.common.byh.entity.VerHospitalListEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import retrofit2.http.Query;

public interface IVerLoginModule {
    /**
     * 账号密码登录
     *
     * @param login
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> userLogin(Login login);

    /**
     * 检测 字段是否完整
     *
     * @return
     */
    Observable<ResponseBody> doctorAddInfoCheck(String doctorId, String organId);

    /**
     * 发送验证码
     *
     * @param mobileNumber
     * @return
     */
    Observable<ResponseBody<VerCodeEntity>> sendVertifyCode(String mobileNumber);

    /**
     * 获得登录认证的状态
     *
     * @param phone
     * @return
     */
    Observable<ResponseBody<VertifyStatus>> getStatus(String phone);


    /**
     * 设置密码
     *
     * @param login {
     *              "accountNo": "18012345678",
     *              "channelCode": "DOCTOR_ANDROID",
     *              "password": "123456"
     *              }
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> setPassword(Login login);

    /**
     * 保存个人信息
     *
     * @param personInfoBody
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> savePersonInfo(String token, PersonInfoBody personInfoBody);


    /**
     * 更新个人认证信息
     *
     * @param reqWebBody {
     *                   "accountId": 0,
     *                   "badgeUrl": "string",
     *                   "headImageUrl": "string",
     *                   "idCardBack": "string",
     *                   "idCardFront": "string"
     *                   }
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> updateCertified(String token, ReqWebBody reqWebBody);


    /**
     * 个人信息认证-获取医院列表
     *
     * @param searchParam
     * @param distCode
     * @param page
     * @param size
     * @return
     */
    Observable<ResponseBody<VerHospitalListEntity>> getVerHospitalList(Long doctorId,
                                                                       Integer page,
                                                                       Integer size,
                                                                       String searchParam,
                                                                       String distCode);

    /**
     * 通过验证码登录
     *
     * @param login
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> loginByVercode(Login login);


    /**
     * 更新用户设备信息
     *
     * @param userDevInfoEntity
     * @return
     */
    Observable<ResponseBody> updateUserDeviceInfo(UserDevInfoEntity userDevInfoEntity);

    /**
     * 添加医院
     *
     * @param hospitalName
     * @return
     */
    Observable<ResponseBody> addHospitalInfo(String hospitalName, Long doctorId, String distCode);

    /**
     * 添加科室
     *
     * @param
     * @return
     */
    Observable<ResponseBody> addHosDepartment(String departmentName,
                                              Long stdFirstDepId,
                                              Long hospitalId,
                                              Long doctorId);

    /**
     * 退出app
     * <p>
     * <<<<<<< HEAD
     *
     * @param ======= >>>>>>> sign_account_br
     * @return
     */
    Observable<ResponseBody> exitApp(LogoutBody body);

    /**
     * 账号注销
     *
     * @param
     * @return
     */
    Observable<ResponseBody> cancelAppAccount(LogoutAccountReqEntity logoutAccountReqEntity);

    /**
     * 验证短信验证码
     *
     * @param reqWebBody {
     *                   "authCode": "验证码",
     *                   "authKey": "每条短信的唯一key，发送时会返回"
     *                   }
     * @return
     */
    Observable<ResponseBody> validatePhoneAndCode(ReqWebBody reqWebBody);

    /**
     * 请求省市区的数据
     *
     * @return
     */
    Observable<ResponseBody<List<AllRegionEntity>>> reqRegionProvinceCityArea();

    /**
     * 根据code 请求微信的token
     *
     * @param code 微信返回的code
     * @return
     */
    @Deprecated
    Observable<ResponseBody<LoginSuccess>> reqWeixToken(String code);

    /**
     * 判断是否绑定微信
     *
     * @param unionId
     * @return
     */
    Observable<ResponseBody<WeixRespTokenEntity>> resHasBindWeix(String unionId);


    /**
     *
     * @param mobileNumber
     * @param openId
     * @param unionId
     * @return
     */

    /**
     * 绑定微信
     *
     * @param reqWebBody {
     *                   "authId": "123456",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "loginDeviceNum": "236511321231441",
     *                   "loginDeviceType": "APP",
     *                   "mobileNumber": "18888888888",
     *                   "openId": "123456",
     *                   "unionId": "123456"
     *                   }
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> reqBindWeChat(ReqWebBody reqWebBody);

    /**
     * 发送验证码
     *
     * @param phoneNum
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> sendSmsAuthCode(String phoneNum);

    /**
     * @param token
     * @param reqWebBody {
     *                   "accountId": "1564315641231",
     *                   "badgeUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "channelCode": "DOCTOR_ANDROID",
     *                   "headImageUrl": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardBack": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg",
     *                   "idCardFront": "https://ss1.bdstatic.com/70cFuXSh_Q1YnxGkpoWK1HF6hhy/it/u=2563087614,1865611305&fm=26&gp=0.jpg"
     *                   }
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> saveCertifyInfo(String token, ReqWebBody reqWebBody);

    /**
     * 修改密码
     *
     * @param login {
     *              "accountId": "string",
     *              "authKey": "string",
     *              "channelCode": "DOCTOR_ANDROID",
     *              "code": "string",
     *              "password": "string",
     *              "passwordNew": "string",
     *              "type": "1短信校验修改、2原密码校验修改"
     *              }
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> updatePassword(Login login);


    /**
     * 微信登录
     *
     * @param login {
     *              "channelCode": "DOCTOR_ANDROID",
     *              "code": "hfuisksd55555648dfd",
     *              "loginDeviceNum": "236511321231441",
     *              "loginDeviceType": "APP"
     *              }
     * @return
     */
    Observable<ResponseBody<LoginSuccess>> loginByWeixin(Login login);

    /**
     * 获取职称列表
     *
     * @param accessToken
     * @param reqWebBody  {
     *                    "channelCode": "DOCTOR_ANDROID",
     *                    "code": "01",
     *                    "type": "gender"
     *                    }
     * @return
     */
    Observable<ResponseBody<List<SelZhicEntity>>> findProfessionalList(String accessToken, ReqWebBody reqWebBody);

    /**
     * 获取医生职业
     */
    Observable<ResponseBody<List<OccupationEntity>>> getOccupation();

    /**
     * 获取医生职称
     */
    Observable<ResponseBody<List<JobTitleEntity>>> getJobTitle(String dicCode);

    /**
     * 获取医生职称
     */
    Observable<ResponseBody> setSiguUP(Map<String, String> reqWebBody);

    //更新医生新手机号
    Observable<ResponseBody<Object>> updateNewPhoneNum(UpdatePhoneParam phoneNumber);

    //更新手机号时 校验密码
    Observable<ResponseBody<Object>> checkPwdForNewPhoneNum(PwdParam pwd);
}
