package com.byh.module.verlogin.present;

import android.content.Context;

import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.WeixRespTokenEntity;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IBindWeChatView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.util.common.DeviceIdUtil;

import com.kangxin.push.PushManager;


public class BindWeixPresent {

    private IVerLoginModule mVerLoginModule;
    private IBindWeChatView mBindWechatView;

    private Context mContext;
    public BindWeixPresent(Context context, IBindWeChatView bindWeChatView){
        mContext = context;
        mBindWechatView = bindWeChatView;
        mVerLoginModule = new VerLoginModule();
    }


    private String mAuthKey;

    /**
     * 发送验证码
     * @param phoneNum
     */
    public void sentVerCode(String phoneNum){
        mVerLoginModule.sendSmsAuthCode(phoneNum)
        .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
            @Override
            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                ToastUtils.showShort(StringsUtils.getString(R.string.verlogin_fasongchenggong));
                mAuthKey = loginSuccessResponseBody.getResult().getAuthKey();
            }
        });

    }

    /**
     * 请求微信登录的接口
     * @param unionId
     */
    private void reqHasBindWeix(String unionId){

        //调用是否绑定了微信，如果绑定了那就返回必要的信息
        mVerLoginModule.resHasBindWeix(unionId)
                .subscribe(new RxProgressObserver<ResponseBody<WeixRespTokenEntity>>() {
                    @Override
                    public void onReqNext(ResponseBody<WeixRespTokenEntity> weixRespTokenEntityResponseBody) {
                        WeixRespTokenEntity weixRespTokenEntity =
                                weixRespTokenEntityResponseBody.getResult();
                        if (weixRespTokenEntity == null){
                            mBindWechatView.onError(StringsUtils.getString(R.string.verlogin_bangdingshibai));
                            return;
                        }

                        LoginSuccess loginSuccess = VertifyDataUtil.getInstance(mContext).getLoginData();
                        if (loginSuccess == null){
                            loginSuccess = new LoginSuccess();
                        }

//                        loginSuccess.setId(weixRespTokenEntity.getId());
//                        loginSuccess.setLoginName(weixRespTokenEntity.getMobileNumber());
//                        loginSuccess.setToken(weixRespTokenEntity.getToken());
//                        loginSuccess.setRongCloudId(weixRespTokenEntity.getRongCloudId());
//                        loginSuccess.setRongCloudToken(weixRespTokenEntity.getRongCloudToken());
//                        loginSuccess.setMobileNumber(weixRespTokenEntity.getMobileNumber());
//                        loginSuccess.setUserType(weixRespTokenEntity.getUserType());

                        VertifyDataUtil.getInstance(mContext).setLoginData(loginSuccess);
                        mBindWechatView.bindWechatSuccess();
                    }
                });

    }

    /**
     * 绑定微信
     * @param mobileNumber
     * @param openId
     * @param unionId
     */
    private void realReqBindWeChat(String mobileNumber, String openId, String unionId, String vercode){
        //绑定微信
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAuthKey(mAuthKey);
        reqWebBody.setCode(vercode);
        reqWebBody.setLoginDeviceNum(PushManager.getDeviceId(mContext, DeviceIdUtil.getDeviceId(mContext)));
        reqWebBody.setMobileNumber(mobileNumber);
        reqWebBody.setOpenId(openId);
        reqWebBody.setUnionId(unionId);

        mVerLoginModule.reqBindWeChat(reqWebBody)
                .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        VertifyDataUtil.getInstance(mContext).setLoginData(loginSuccessResponseBody.getResult());

                        mBindWechatView.bindWechatSuccess();
                    }
                });

    }

    /**
     * 请求绑定微信
     * @param verCode 验证码
     * @param mobileNumber 手机号
     * @param openId openid
     * @param unionId unionId
     */
    public void reqBindWeChat(String verCode, String mobileNumber, String openId, String unionId){


        //验证验证码是否正确
        ReqWebBody authCodeReqWebBody = new ReqWebBody();
        authCodeReqWebBody.setAuthCode(verCode);
        authCodeReqWebBody.setAuthKey(mAuthKey);


        realReqBindWeChat(mobileNumber, openId, unionId, verCode);


//        mVerLoginModule.validatePhoneAndCode(authCodeReqWebBody)
//                .subscribe(new RxProgressObserver<ResponseBody>() {
//                    @Override
//                    public void onReqNext(ResponseBody responseBody) {
//                        realReqBindWeChat(mobileNumber, openId, unionId);
//                    }
//                });

    }

}
