package com.byh.module.verlogin.present;

import android.content.Context;
import android.util.Log;

import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.intercept.RxLoginCommonObserver;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.present.inter.IPushBindPresenter;
import com.byh.module.verlogin.view.ILoginByCodeOkView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.widget.RxProgressObserver;

import org.greenrobot.eventbus.EventBus;

public class LoginByVercodePresent {
    private static final String TAG = "LoginByVercodePresent";
    private ILoginByCodeOkView mLoginByCodeView;
    private IVerLoginModule mLoginModel;

    private IPushBindPresenter pushBindPresenter;


    public LoginByVercodePresent(ILoginByCodeOkView mLoginByCodeView) {
        this.mLoginByCodeView = mLoginByCodeView;
        mLoginModel = new VerLoginModule();
        pushBindPresenter = new PushBindPresenter(mLoginByCodeView.injectContext());
    }

    /**
     * @param context
     * @param login   {
     *                "accountNo": "18012345678",
     *                "authKey": "authKey",
     *                "channelCode": "DOCTOR_ANDROID",
     *                "code": "123456",
     *                "loginDeviceNum": "236511321231441",
     *                "loginDeviceType": "APP"
     *                }
     */
    public void loginByVercode(Context context, Login login) {

        mLoginModel.loginByVercode(login)
                .subscribe(new RxLoginCommonObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        VertifyDataUtil.getInstance(context).setLoginData(loginSuccessResponseBody.getResult());
                        if (null != loginSuccessResponseBody.getData().getDoctorLoginInfo()) {
                          doctorzraddInfo(context, loginSuccessResponseBody.getData().getDoctorLoginInfo().getDoctorId(),
                                  loginSuccessResponseBody.getData().getDoctorLoginInfo().getOrganId());
                        }
                        mLoginByCodeView.loginByCodeOk(loginSuccessResponseBody.getResult(), loginSuccessResponseBody.getMsg());
                        super.onReqNext(loginSuccessResponseBody);
                    }
                });

    }

    public void doctorzraddInfo(Context context, String doctorId, String organId) {
        mLoginModel.doctorAddInfoCheck(doctorId, organId)
                .subscribe(new RxProgressObserver<ResponseBody>() {
                    @Override
                    public void onReqNext(ResponseBody loginSuccessResponseBody) {
                        VertifyDataUtil.getInstance(context).setInfoCheck((Boolean) loginSuccessResponseBody.getData());
                        EventBus.getDefault().post(new Event.infoCheck((Boolean) loginSuccessResponseBody.getData()));
                        Log.e("Event.infoCheck---4",loginSuccessResponseBody.getData()+"");

                    }
                });
    }
}
