package com.byh.module.verlogin.present;

import com.byh.module.verlogin.entity.LogoutAccountReqEntity;
import com.byh.module.verlogin.intercept.RxLoginCommonObserver;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.ILogoutAccountView;
import com.kangxin.common.base.ResponseBody;

public class LogoutAccountPresent {
    private static final String TAG = "LogoutAccountPresent";
    private ILogoutAccountView mLogoutAccountView;
    private IVerLoginModule mLoginModel;

    public LogoutAccountPresent(ILogoutAccountView logoutAccountView) {
        this.mLogoutAccountView = logoutAccountView;
        mLoginModel = new VerLoginModule();
    }

    /**
     * @param logoutAccountReqEntity {
     *                               "accountId": "182174674954747904",
     *                               "channelCode": "",
     *                               "needCheckPw": false
     *                               }
     */
    public void logoutAppAccount(LogoutAccountReqEntity logoutAccountReqEntity) {
        mLoginModel.cancelAppAccount(logoutAccountReqEntity)
                .subscribe(new RxLoginCommonObserver<ResponseBody>() {
                    @Override
                    public void onReqNext(ResponseBody body) {
                        mLogoutAccountView.logoutAccountOk();
                    }
                });
    }
}
