package com.byh.module.verlogin.present;


import android.content.Context;
import android.util.Log;

import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.intercept.RxLoginCommonObserver;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.present.inter.IPushBindPresenter;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;

import org.greenrobot.eventbus.EventBus;


public class VerLoginPresent {

  private static final String TAG = "VerLoginPresent";

  private ILoginView mLoginView;
  private IVerLoginModule mVerLoginModule;

  private IPushBindPresenter pushBindPresenter;


  public VerLoginPresent(ILoginView mLoginView) {
    this.mLoginView = mLoginView;
    mVerLoginModule = new VerLoginModule();
    pushBindPresenter = new PushBindPresenter(mLoginView.injectContext());
  }


  public void loginApp(Context context, Login login) {
    mVerLoginModule.userLogin(login)
      .subscribe(new RxLoginCommonObserver<ResponseBody<LoginSuccess>>() {
        @Override
        public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
          VertifyDataUtil.getInstance(context).setLoginData(loginSuccessResponseBody.getResult());
          updateUserInfo(context);
          UpdateVerStatus.getInstance().updateImToken(context);
          if (null != loginSuccessResponseBody.getData().getDoctorLoginInfo()) {
            doctorzraddInfo(context, loginSuccessResponseBody.getResult().getAccountStatus(), loginSuccessResponseBody.getData().getDoctorLoginInfo().getDoctorId(),
              loginSuccessResponseBody.getData().getDoctorLoginInfo().getOrganId());
          } else {
            mLoginView.loginOk(loginSuccessResponseBody);
          }
          super.onReqNext(loginSuccessResponseBody);
        }
      });
  }


  public void doctorzraddInfo(Context context, int status, String doctorId, String organId) {
    mVerLoginModule.doctorAddInfoCheck(doctorId, organId)
      .subscribe(new RxProgressObserver<ResponseBody>() {
        @Override
        public void onReqNext(ResponseBody loginSuccessResponseBody) {
          VertifyDataUtil.getInstance(context).setInfoCheck((Boolean) loginSuccessResponseBody.getData());
          EventBus.getDefault().post(new Event.infoCheck((Boolean) loginSuccessResponseBody.getData()));
          Log.e("Event.infoCheck---1", loginSuccessResponseBody.getData() + "");
          mLoginView.getCheck(status);

        }
      });
  }


  private void updateUserInfo(Context context) {
    UpdateVerStatus.getInstance().updateDocDetailInfo(context,
      new IUpdateVerStatus.OnUpdateDocDetailInfoCallback() {
        @Override
        public void updateDocDetailInfoOk() {
        }

        @Override
        public void updateDocDetailInfoErr(String err) {
          ToastUtils.showShort(err);
        }
      });
  }

  private String mAuthKey;

  public String getAuthKey() {
    return mAuthKey;
  }

  public void sentVerCode(String phoneNum) {

    mVerLoginModule.sendSmsAuthCode(phoneNum)
      .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
        @Override
        public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {

          mAuthKey = loginSuccessResponseBody.getResult().getAuthKey();
          ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_fasongchenggong));
          mLoginView.receiveVercode();
        }

        @Override
        public void onReqErr(Throwable e) {
          ToastUtils.showLong(StringsUtils.getString(R.string.verlogin_fasongchenggong_shibai));

        }
      });
  }

  /**
   * 设置密码
   *
   * @param login {
   *              "accountNo": "18012345678",
   *              "channelCode": "DOCTOR_ANDROID",
   *              "loginDeviceNum": "236511321231441",
   *              "loginDeviceType": "APP",
   *              "password": "123456"
   *              }
   */
  public void setPassword(Context context, Login login) {
    mVerLoginModule.setPassword(login)
      .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
        @Override
        public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
          LoginSuccess loginSuccess = loginSuccessResponseBody.getResult();

          VertifyDataUtil.getInstance(context).setToken(loginSuccess.getToken());
          VertifyDataUtil.getInstance(context).setAccountStatus(loginSuccess.getAccountStatus());
          VertifyDataUtil.getInstance(context).setAccountId(loginSuccess.getAccountId());
          mLoginView.setPwdOk(loginSuccessResponseBody.getMsg());
        }
      });

  }

  /**
   * 修改密码
   *
   * @param login {
   *              "accountId": "string",
   *              "authKey": "string",
   *              "channelCode": "DOCTOR_ANDROID",
   *              "code": "string",
   *              "password": "string",
   *              "passwordNew": "string",
   *              "type": StringsUtils.getString(R.string.verlogin_1duanxinxiaoyanxiugai_2yuanmimaxiaoyanxiugai)
   *              }
   */
  public void updatePassword(Login login) {
    mVerLoginModule.updatePassword(login)
      .subscribe(new RxProgressObserver<ResponseBody<LoginSuccess>>() {
        @Override
        public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
          mLoginView.setPwdOk(loginSuccessResponseBody.getMsg());
        }
      });
  }

}
