package com.byh.module.verlogin.present;

import com.byh.module.verlogin.entity.VertifyStatus;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.view.IVertifyStatusView;
import com.kangxin.common.base.ResponseBody;


import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

public class VertifyStatusPresent {
    private VerLoginModule mVerLoginModule;
    private IVertifyStatusView mVertifyStatusView;

    public VertifyStatusPresent(IVertifyStatusView vertifyStatusView){
        mVertifyStatusView = vertifyStatusView;
        mVerLoginModule = new VerLoginModule();
    }


    public void getVertifyStatus(String phoneNum){
        mVerLoginModule.getStatus(phoneNum).subscribe(new Observer<ResponseBody<VertifyStatus>>() {
            @Override
            public void onSubscribe(Disposable d) {

            }

            @Override
            public void onNext(ResponseBody<VertifyStatus> vertifyStatusResponseBody) {
                mVertifyStatusView.vertifyStatus(vertifyStatusResponseBody.getResult());
            }

            @Override
            public void onError(Throwable e) {
                mVertifyStatusView.vertifyErr(e.toString());
            }

            @Override
            public void onComplete() {

            }
        });
    }
}
