package com.byh.module.verlogin.provider;

import android.content.Context;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.entity.LogoutBody;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.service.IExitAppService;
import com.kangxin.common.widget.RxProgressObserver;

@Route(path = VerloginRouter.EXIT_APP_SERVICE)
public class ExitAppServiceImpl implements IExitAppService {

    private Context context;

    @Override
    public void exitApp(
            String deviceNumber,
            String deviceType,
            String accountId,
            String userId,
            String appCode,
            String channelCode, OnExitAppListener onExitAppListener) {
        new VerLoginModule().exitApp(new LogoutBody(deviceNumber, deviceType, accountId, userId, appCode, channelCode))
                .subscribe(new RxProgressObserver<ResponseBody>() {
                    @Override
                    public void onReqNext(ResponseBody responseBody) {
                        onExitAppListener.onExitAppOk();
                    }

                    @Override
                    public void onError(Throwable e) {
                        super.onError(e);

                        ToastUtils.showLong(e.toString());
                    }
                });
    }

    @Override
    public void init(Context context) {
        this.context = context;
    }
}
