package com.byh.module.verlogin.utils;

import android.content.Context;
import android.os.Debug;
import android.text.TextUtils;
import android.util.Log;

import com.alibaba.android.arouter.facade.annotation.Route;
import com.byh.module.onlineoutser.im.utils.DateUtils;
import com.byh.module.verlogin.entity.VertifyStatus;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.ExpertInfoEntity;
import com.kangxin.common.byh.entity.req.ReqWebBody;
import com.kangxin.common.byh.entity.req.UserChanBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.global.router.VerloginRouter;
import com.kangxin.common.byh.module.impl.GlobalModule;
import com.kangxin.common.byh.module.impl.ImModelmpl;
import com.kangxin.common.byh.module.impl.UserModule;
import com.kangxin.common.byh.provider.UserSignProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.rx.SampleObserver;
import com.kangxin.common.widget.RxBaseObserver;
import com.kangxin.common.widget.RxProgressObserver;
import com.kangxin.util.common.SPUtils;

import org.greenrobot.eventbus.EventBus;

import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;

import static com.kangxin.common.byh.event.ByhCommEvent.UpdatePersonalCenter.REQUESTINTG_ERROR;
import static com.kangxin.common.byh.event.ByhCommEvent.UpdatePersonalCenter.REQUESTINTG_STATUS;
import static com.kangxin.common.byh.event.ByhCommEvent.UpdatePersonalCenter.REQUESTINTG_SUCCESS;
import static com.kangxin.common.byh.global.Global.CONSU_STATUS_CHECK;
import static com.kangxin.common.byh.global.Global.CONSU_STATUS_KEY;

@Route(path = VerloginRouter.UPDATE_VER_STATUS)
public class UpdateVerStatus implements IUpdateVerStatus {

    private static final String TAG = "UpdateVerStatus";
    private static final UpdateVerStatus ourInstance = new UpdateVerStatus();

    public static UpdateVerStatus getInstance() {
        return ourInstance;
    }

    public UpdateVerStatus() {
    }

    /**
     * 改变会诊状态
     *
     * @param context
     * @param status
     */
    @Override
    public void changeConsuStatus(Context context, @ConsuStatus int status) {

        SPUtils.setSharedIntData(context, CONSU_STATUS_KEY, status);
    }

    /**
     * 检验状态
     *
     * @param context
     * @param status
     */
    @Override
    public void changeConsuStatus(Context context, boolean status) {

        SPUtils.setSharedBooleanData(context, CONSU_STATUS_CHECK, status);
    }

    @Override
    public int getConsuStatus(Context context) {
        return SPUtils.getSharedIntData(context, CONSU_STATUS_KEY);
    }

    @Override
    public boolean getConsuCheck(Context context) {
        return SPUtils.getSharedBooleanData(context, CONSU_STATUS_CHECK);
    }

    /**
     * 更新验证状态
     */
    @Override
    @Deprecated
    public void updateVertifyStatus(Context context) {

        LoginSuccess loginSuccess = VertifyDataUtil.getInstance(context).getLoginData();
        if (loginSuccess == null) {
            return;
        }

        String phoneNum = "";
        if (TextUtils.isEmpty(phoneNum)) {
            return;
        }

        updateVertifyStatus(loginSuccess, phoneNum, context);
    }

    @Override
    public void updateDocDetailInfo(Context context, IUpdateVerStatus.OnUpdateDocDetailInfoCallback onUpdateDocDetailInfoCallback) {

        String accountId = VertifyDataUtil.getInstance(context).getAccountId();
        if (TextUtils.isEmpty(accountId) || "-1".equals(accountId)) {
            if (onUpdateDocDetailInfoCallback != null) {
                onUpdateDocDetailInfoCallback.updateDocDetailInfoOk();
            }
            return;
        }

        UserChanBody userChanBody = new UserChanBody();
        userChanBody.setAccountId(accountId);
        userChanBody.setAccountStatus(VertifyDataUtil.getInstance(context).getAcountStatus() + "");

        new UserModule().getExpertInfos
                (userChanBody).subscribe(new Observer<ResponseBody<ExpertInfoEntity>>() {
            @Override
            public void onSubscribe(Disposable d) {
                EventBus.getDefault().postSticky(new ByhCommEvent.UpdatePersonalCenter(REQUESTINTG_STATUS));
            }

            @Override
            public void onNext(ResponseBody<ExpertInfoEntity> expertInfoEntityResponseBody) {

                ExpertInfoEntity expertInfoEntity = expertInfoEntityResponseBody.getResult();
                if (expertInfoEntity == null) {
                    //如果请求的数据是空的话，就再次请求一次获取用户状态的接口
                    if (onUpdateDocDetailInfoCallback != null) {
                        onUpdateDocDetailInfoCallback.updateDocDetailInfoOk();
                    }

                    return;
                }

                new Thread(new Runnable() {
                  @Override
                  public void run() {
                    VertifyDataUtil.getInstance(context).setDocDetailInfo(expertInfoEntity);
                    VertifyDataUtil.getInstance(context).setAccountStatus(expertInfoEntity.getAccountStatus());
                  }
                }).start();

                LoginSuccess loginSuccess = expertInfoEntity.getCloudAccountLoginRespVO();
                long otherTime = System.currentTimeMillis();
                if (loginSuccess != null) {
                    doctorzraddInfo(context, loginSuccess.getDoctorLoginInfo().getDoctorId(),
                            loginSuccess.getDoctorLoginInfo().getOrganId());
                    LoginSuccess localLoginData = VertifyDataUtil.getInstance(context).getLoginData();
                    if (localLoginData != null) {
                        loginSuccess = localLoginData.updateLoginData(loginSuccess);
                    }
                    VertifyDataUtil.getInstance(context).setLoginData(loginSuccess);
                }
                  //融云
//                if (expertInfoEntity.isRefresh()) {
//                    updateImToken(context);
//                }

                if (onUpdateDocDetailInfoCallback != null) {
                    onUpdateDocDetailInfoCallback.updateDocDetailInfoOk();
                }
            }

            @Override
            public void onError(Throwable e) {
                //请求出错之后再请求一次获取用户状态的接口
                if (onUpdateDocDetailInfoCallback != null) {
                    onUpdateDocDetailInfoCallback.updateDocDetailInfoErr(e.toString());
                }

                //获取userSign 进行更新
                UserSignProvider.getInstance().reqTecentUserSign(null);
                EventBus.getDefault().postSticky(new ByhCommEvent.UpdatePersonalCenter(REQUESTINTG_ERROR));
            }

            @Override
            public void onComplete() {
                EventBus.getDefault().postSticky(new ByhCommEvent.UpdatePersonalCenter(REQUESTINTG_SUCCESS));
            }
        });
    }


    public void doctorzraddInfo(Context context, String doctorId, String organId) {
        new UserModule().doctorAddInfoCheck(doctorId, organId)
                .subscribe(new RxProgressObserver<ResponseBody>() {
                    @Override
                    public void onReqNext(ResponseBody loginSuccessResponseBody) {
                        VertifyDataUtil.getInstance(context).setInfoCheck((Boolean) loginSuccessResponseBody.getData());
                        EventBus.getDefault().post(new Event.infoCheck(((Boolean) loginSuccessResponseBody.getData())));
                    }
                });
    }

    /**
     * 请求获取用户状态
     *
     * @param context
     */
    public void reqUpdateAccountStatus(Context context) {

        String accountNo = VertifyDataUtil.getInstance(context).getAccountNo();
        ReqWebBody reqWebBody = new ReqWebBody();
        reqWebBody.setAccountNo(accountNo);
        new GlobalModule().getAccountStatus(reqWebBody)
                .subscribe(new RxBaseObserver<ResponseBody<LoginSuccess>>() {
                    @Override
                    public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                        LoginSuccess loginSuccess = loginSuccessResponseBody.getResult();
                        if (loginSuccess != null) {
                            VertifyDataUtil.getInstance(context).setAccountStatus(loginSuccess.getAccountStatus());
                            updateDocDetailInfo(context, null);
                        }
                    }

                    @Override
                    public void onError(Throwable e) {

                    }

                    @Override
                    public void onComplete() {

                    }
                });
    }

    @Deprecated
    public void updateVertifyStatus(LoginSuccess loginSuccess, String phoneNum, Context context) {
        new VerLoginModule().getStatus(phoneNum)
                .subscribe(new SampleObserver<ResponseBody<VertifyStatus>>() {
                    @Override
                    public void onNext(ResponseBody<VertifyStatus> vertifyStatusResponseBody) {

                        VertifyStatus vertifyStatus = vertifyStatusResponseBody.getResult();
                        String rongToken = vertifyStatus.getRongCloudToken();
                        if (!TextUtils.isEmpty(rongToken)) {
                            VertifyDataUtil.getInstance(context).setLoginData(loginSuccess);
                        }
                        VertifyDataUtil.getInstance(context).setVertifyStatus(vertifyStatus.getCode());
                        int status = VertifyDataUtil.getInstance(context).getVertifyStatus();
                        Log.i(TAG, "onReqNext==status==>" + status);

                        EventBus.getDefault().post(new Event.VerStatusEvent(vertifyStatus.getCode()));
                    }

                });
    }


    public void updateImToken(Context context) {
        String userId = VertifyDataUtil.getInstance(context).getDoctorId();
//        Log.i(TAG, "userId===>" + userId);

        /*if (!TextUtils.isEmpty(userId)) {
            new ImModelmpl().getImTokenById(userId)
                    .subscribe(new RxBaseObserver<ResponseBody<LoginSuccess>>() {
                        @Override
                        public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                            LoginSuccess loginSuccess = loginSuccessResponseBody.getResult();
                            if (loginSuccess != null) {
                                LoginSuccess localData = VertifyDataUtil.getInstance(context).getLoginData();
                                if (localData == null) {
                                    localData = new LoginSuccess();
                                }

                                String rongCloundId = loginSuccess.getRongCloundId();
                                localData.setRongCloundId(rongCloundId);
                                localData.setRongCloudToken(loginSuccess.getRongCloudToken());

                                VertifyDataUtil.getInstance(context).setLoginData(localData);

                            }
                          EventBus.getDefault().postSticky(new ByhCommEvent.ConnectImEvent());
                        }

                        @Override
                        public void onError(Throwable e) {

                        }

                        @Override
                        public void onComplete() {

                        }
                    });
        }*/
    }

    public interface OnUpdateDocDetailInfoCallback {
        void updateDocDetailInfoOk();

        void updateDocDetailInfoErr(String err);
    }

    @Override
    public void init(Context context) {

    }

}
