/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.event.vertify.LoginDispatchStatus;
import com.byh.module.verlogin.event.vertify.LoginStatusManager;
import com.byh.module.verlogin.present.BindWeixPresent;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.IBindWeChatView;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.util.CountDownUtil;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.util.common.VerifyUtil;
import com.kangxin.widget.common.byh.ZpPhoneEditText;

@Route(path="/VerloginRouter/authwechat/BindWeixActivity")
public class BindWeixActivity
extends BaseActivity
implements IBindWeChatView {
    private TextView mVercodeText;
    private CountDownUtil mCountDownUtil;
    private ZpPhoneEditText mPhoneNumEdit;
    private ImageView mClosePhoneNumImg;
    private BindWeixPresent mBindWechatPresent;
    private EditText mVercodeEdt;
    TextView mErrNoticeText;
    private Button mBindBtn;

    @RequiresApi(api=16)
    public void start() {
        this.mBindWechatPresent = new BindWeixPresent(this.getBaseContext(), this);
        ImageView backImgView = (ImageView)this.findViewById(R.id.img_back_ver);
        backImgView.setImageResource(R.drawable.ic_gray_fanhui);
        this.mBindBtn = (Button)this.findViewById(R.id.bt_login);
        this.mBindBtn.setText((CharSequence)StringsUtils.getString((int)R.string.verlogin_bangdingshoujihao));
        this.hideNouseViews();
        this.mVercodeText = (TextView)this.findViewById(R.id.vercode_txt);
        this.mPhoneNumEdit = (ZpPhoneEditText)this.findViewById(R.id.edt_phonenum);
        this.mClosePhoneNumImg = (ImageView)this.findViewById(R.id.clearlogin_img);
        this.mVercodeEdt = (EditText)this.findViewById(R.id.edt_vercode);
        this.mErrNoticeText = (TextView)this.findViewById(R.id.err_notice);
        this.mClosePhoneNumImg.setOnClickListener(view -> this.mPhoneNumEdit.setText((CharSequence)""));
        this.mCountDownUtil = new CountDownUtil(this.mVercodeText).setCountDownMillis(60000L).setCountDownColor(R.color.white, 0x1060000);
        this.isVercodeUsable(false);
        this.mCountDownUtil.setOnDownEndListener(() -> {
            String phoneNum = this.mPhoneNumEdit.getPhoneText();
            if (!TextUtils.isEmpty((CharSequence)phoneNum)) {
                this.isVercodeUsable(true);
            } else {
                this.isVercodeUsable(false);
            }
        });
        this.mVercodeText.setOnClickListener(view -> {
            String phoneNum = this.mPhoneNumEdit.getPhoneText();
            if (TextUtils.isEmpty((CharSequence)phoneNum)) {
                return;
            }
            this.mBindWechatPresent.sentVerCode(phoneNum);
            this.mCountDownUtil.start();
            this.isVercodeUsable(false);
        });
        this.addEdtChangeListener();
    }

    private void addEdtChangeListener() {
        this.mPhoneNumEdit.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                BindWeixActivity.this.mErrNoticeText.setVisibility(8);
                String phoneNum = BindWeixActivity.this.mPhoneNumEdit.getPhoneText();
                if (VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
                    BindWeixActivity.this.isVercodeUsable(true);
                } else {
                    BindWeixActivity.this.isVercodeUsable(false);
                }
            }
        });
        this.mVercodeEdt.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                BindWeixActivity.this.mErrNoticeText.setVisibility(8);
                if (editable.length() == 6) {
                    BindWeixActivity.this.mBindBtn.setClickable(true);
                    BindWeixActivity.this.mBindBtn.setBackground(ResourcesCompat.getDrawable((Resources)BindWeixActivity.this.getResources(), (int)R.drawable.vercode_order_bg, null));
                } else {
                    BindWeixActivity.this.mBindBtn.setClickable(false);
                    BindWeixActivity.this.mBindBtn.setBackground(ResourcesCompat.getDrawable((Resources)BindWeixActivity.this.getResources(), (int)R.drawable.bt_gray_order_bg, null));
                }
            }
        });
    }

    @RequiresApi(api=16)
    private void isVercodeUsable(boolean isUse) {
        if (isUse) {
            this.mCountDownUtil.setUsable(true);
            this.mVercodeText.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
            this.mVercodeText.setTextColor(this.getResources().getColor(17170443));
            this.mVercodeText.setClickable(true);
            this.mVercodeText.setFocusable(true);
            this.mVercodeText.setText(R.string.ver_getvercode);
        } else {
            this.mCountDownUtil.setUsable(false);
            this.mVercodeText.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.edt_order_bg, null));
            this.mVercodeText.setTextColor(this.getResources().getColor(0x1060000));
            this.mVercodeText.setText(R.string.ver_getvercode);
            this.mVercodeText.setClickable(false);
            this.mVercodeText.setFocusable(false);
        }
    }

    private void hideNouseViews() {
        this.findViewById(R.id.txt_pwd_login).setVisibility(8);
        this.findViewById(R.id.xieyi_linea).setVisibility(8);
        this.findViewById(R.id.lieanr_weixin).setVisibility(8);
    }

    public int getContentLayoutId() {
        return R.layout.activity_ver_login;
    }

    public void clickLogin(View view) {
        String openId = this.getIntent().getStringExtra("OPEN_ID_KEY");
        String unionId = this.getIntent().getStringExtra("UNIONID_KEY");
        String verCode = this.mVercodeEdt.getText().toString().trim();
        String phoneNum = this.mPhoneNumEdit.getPhoneText();
        if (!VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
            this.mErrNoticeText.setVisibility(0);
            this.mErrNoticeText.setText((CharSequence)StringsUtils.getString((int)R.string.verlogin_shoujihaogeshibuzhengque));
            return;
        }
        this.mBindWechatPresent.reqBindWeChat(verCode, phoneNum, openId, unionId);
    }

    public void clickBack(View view) {
        this.finish();
    }

    @Override
    public void bindWechatSuccess() {
        int status = VertifyDataUtil.getInstance((Context)this.getBaseContext()).getAcountStatus();
        LoginDispatchStatus loginDispatchStatus = new LoginDispatchStatus();
        loginDispatchStatus.registerStatus(new LoginStatusManager((Activity)this));
        loginDispatchStatus.dispatchStatus(status);
        this.updateInfoStatus();
        this.finish();
    }

    private void updateInfoStatus() {
        UpdateVerStatus.getInstance().updateDocDetailInfo(this.getBaseContext(), new IUpdateVerStatus.OnUpdateDocDetailInfoCallback(){

            public void updateDocDetailInfoOk() {
                BindWeixActivity.this.finish();
            }

            public void updateDocDetailInfoErr(String err) {
                BindWeixActivity.this.showShortToast(err);
            }
        });
    }

    public void onError(String msg) {
        this.mCountDownUtil.reset();
        this.mErrNoticeText.setVisibility(0);
        this.mErrNoticeText.setText((CharSequence)msg);
    }

    public boolean initYm() {
        return false;
    }
}

