/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Build;
import android.os.CountDownTimer;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.module.ChangePhoneViewModel;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.base.kt.BaseActivity;
import com.kangxin.common.byh.service.IExitAppProvider;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.util.common.VerifyUtil;

public class ChangePhoneNewNumActivity
extends BaseActivity {
    private TextView tv_code;
    private EditText ed_code;
    private EditText ed_tel;
    private Button tv_next;
    private CountDownTimer timer;
    private ChangePhoneViewModel viewModel;
    private String codeKey = "";
    private IExitAppProvider mExitAppProvider = (IExitAppProvider)ARouter.getInstance().build("/AppRouter/exit/app/ExitAppProvider").navigation();

    public int getContentLayoutId() {
        return R.layout.activity_change_phone_new_num;
    }

    public void start() {
        this.tv_code = (TextView)this.findViewById(R.id.tv_code);
        this.ed_code = (EditText)this.findViewById(R.id.et_code);
        this.tv_next = (Button)this.findViewById(R.id.code_next);
        this.ed_tel = (EditText)this.findViewById(R.id.et_tel);
        this.tv_next.setClickable(false);
        this.tv_next.setEnabled(false);
        this.isVercodeUsable(false);
        this.viewModel = (ChangePhoneViewModel)new ViewModelProvider((ViewModelStoreOwner)this).get(ChangePhoneViewModel.class);
        this.tv_code.setOnClickListener(view -> {
            if (TextUtils.isEmpty((CharSequence)this.ed_tel.getText().toString().trim())) {
                this.showShortToast("\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u91cd\u65b0\u8f93\u5165");
                return;
            }
            this.sendCode(this.ed_tel.getText().toString().trim());
        });
        this.findViewById(R.id.vLeftImage).setOnClickListener(v -> {
            this.cancelCountDownTimer();
            this.finish();
        });
        this.tv_next.setOnClickListener(v -> {
            if (TextUtils.isEmpty((CharSequence)this.ed_tel.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)this.ed_code.getText().toString().trim()) || TextUtils.isEmpty((CharSequence)this.codeKey)) {
                this.showShortToast("\u9a8c\u8bc1\u7801\u9519\u8bef,\u8bf7\u91cd\u65b0\u83b7\u53d6");
                return;
            }
            this.checkCode();
        });
        this.ed_tel.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void afterTextChanged(Editable editable) {
                String phoneNum = ChangePhoneNewNumActivity.this.ed_tel.getText().toString();
                if (VerifyUtil.isMobilePhoneNumber((String)phoneNum)) {
                    ChangePhoneNewNumActivity.this.isVercodeUsable(true);
                } else {
                    ChangePhoneNewNumActivity.this.isVercodeUsable(false);
                }
            }
        });
        this.ed_code.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            public void onTextChanged(CharSequence charSequence, int i, int i1, int i2) {
            }

            @RequiresApi(api=16)
            public void afterTextChanged(Editable editable) {
                if (editable.length() == 6) {
                    ChangePhoneNewNumActivity.this.tv_next.setClickable(true);
                    ChangePhoneNewNumActivity.this.tv_next.setEnabled(true);
                    ChangePhoneNewNumActivity.this.tv_next.setTextColor(ChangePhoneNewNumActivity.this.getResources().getColor(R.color.white));
                    ChangePhoneNewNumActivity.this.tv_next.setBackground(ResourcesCompat.getDrawable((Resources)ChangePhoneNewNumActivity.this.getResources(), (int)R.drawable.vercode_order_bg, null));
                } else {
                    ChangePhoneNewNumActivity.this.tv_next.setClickable(false);
                    ChangePhoneNewNumActivity.this.tv_next.setEnabled(false);
                    ChangePhoneNewNumActivity.this.tv_next.setTextColor(ChangePhoneNewNumActivity.this.getResources().getColor(R.color.color_999999));
                    ChangePhoneNewNumActivity.this.tv_next.setBackground(ResourcesCompat.getDrawable((Resources)ChangePhoneNewNumActivity.this.getResources(), (int)R.drawable.bt_gray_order_bg, null));
                }
            }
        });
    }

    private void sendCode(String mPhoneNum) {
        this.viewModel.getCodeByPhone(mPhoneNum).observe((LifecycleOwner)this, (Observer)new Observer<String>(){

            public void onChanged(String s) {
                ChangePhoneNewNumActivity.this.codeKey = s;
                ChangePhoneNewNumActivity.this.ed_tel.setFocusable(false);
                ChangePhoneNewNumActivity.this.ed_tel.setFocusableInTouchMode(false);
                ChangePhoneNewNumActivity.this.isVercodeUsable(false);
                ChangePhoneNewNumActivity.this.starCountDownTimer();
            }
        });
    }

    private void checkCode() {
        this.viewModel.checkCode(this.ed_code.getText().toString().trim(), this.codeKey).observe((LifecycleOwner)this, (Observer)new Observer<ResponseBody>(){

            public void onChanged(ResponseBody responseBody) {
                if (responseBody.getCode() == 200) {
                    ChangePhoneNewNumActivity.this.updateNewPhone();
                } else {
                    if (responseBody.getMsg().contains("\u5df2\u5931\u6548")) {
                        ChangePhoneNewNumActivity.this.showShortToast(responseBody.getMsg());
                    } else {
                        ChangePhoneNewNumActivity.this.showShortToast("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
                    }
                    ChangePhoneNewNumActivity.this.codeKey = "";
                    ChangePhoneNewNumActivity.this.isVercodeUsable(true);
                    ChangePhoneNewNumActivity.this.cancelCountDownTimer();
                    ChangePhoneNewNumActivity.this.ed_tel.setFocusable(true);
                    ChangePhoneNewNumActivity.this.ed_tel.setFocusableInTouchMode(true);
                }
            }
        });
    }

    private void updateNewPhone() {
        String accountNo = VertifyDataUtil.getInstance((Context)this).getAccountNo();
        this.viewModel.updateNewPhoneNum(accountNo, "DOCTOR_ANDROID", this.ed_tel.getText().toString().trim()).observe((LifecycleOwner)this, (Observer)new Observer<ResponseBody>(){

            public void onChanged(ResponseBody responseBody) {
                ChangePhoneNewNumActivity.this.showShortToast(responseBody.getMsg());
                if (responseBody.getCode() == 200) {
                    if (Build.VERSION.SDK_INT >= 26) {
                        ChangePhoneNewNumActivity.this.mExitAppProvider.registerExitAppReceiver();
                        ChangePhoneNewNumActivity.this.mExitAppProvider.sendExitAppReceiver();
                    } else {
                        Intent intent = new Intent("com.kangxin.doctor.worktable.exitapp");
                        ChangePhoneNewNumActivity.this.sendBroadcast(intent);
                    }
                }
            }
        });
    }

    private void isVercodeUsable(boolean isUse) {
        if (isUse) {
            this.tv_code.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.vercode_order_bg, null));
            this.tv_code.setTextColor(this.getResources().getColor(17170443));
            this.tv_code.setClickable(true);
            this.tv_code.setFocusable(true);
            this.tv_code.setText(R.string.ver_getvercode);
        } else {
            this.tv_code.setBackground(ResourcesCompat.getDrawable((Resources)this.getResources(), (int)R.drawable.white_corner_bg, null));
            this.tv_code.setTextColor(this.getResources().getColor(0x1060000));
            this.tv_code.setText(R.string.ver_getvercode);
            this.tv_code.setClickable(false);
            this.tv_code.setFocusable(false);
        }
    }

    private void cancelCountDownTimer() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = null;
    }

    private void starCountDownTimer() {
        if (this.timer == null) {
            this.timer = new CountDownTimer(60000L, 1000L){

                public void onTick(long millisUntilFinished) {
                    ChangePhoneNewNumActivity.this.tv_code.setText((CharSequence)(millisUntilFinished / 1000L + "s"));
                }

                public void onFinish() {
                    ChangePhoneNewNumActivity.this.isVercodeUsable(true);
                    ChangePhoneNewNumActivity.this.ed_tel.setFocusable(true);
                    ChangePhoneNewNumActivity.this.ed_tel.setFocusableInTouchMode(true);
                    ChangePhoneNewNumActivity.this.cancelCountDownTimer();
                }
            };
            this.timer.start();
        }
    }

    public boolean initYm() {
        return false;
    }

    protected void onDestroy() {
        super.onDestroy();
        this.cancelCountDownTimer();
        if (this.mExitAppProvider != null) {
            this.mExitAppProvider.unRegisterExitAppReceiver();
        }
    }
}

