/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.fragment;

import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.alibaba.android.arouter.launcher.ARouter;
import com.byh.module.verlogin.R;
import com.kangxin.common.base.kt.BaseFragment;
import com.kangxin.common.byh.event.ByhCommEvent;
import com.kangxin.common.byh.inter.ISupportFragmentObservable;
import com.kangxin.common.byh.service.HosCityListService;
import me.yokeyword.fragmentation.ISupportFragment;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class YiyuanNameFragment
extends BaseFragment {
    private static final String TAG = "YiyuanNameFragment";
    private boolean isShowCityPage = true;
    private String mAreaCode = "";
    private ByhCommEvent.CityEntity mCityEntity;

    @RequiresApi(api=3)
    public void init() {
        this.hideSoftInput();
        this.initSearchHospital();
        HosCityListService hosCityListService = (HosCityListService)ARouter.getInstance().build("/WorkTableRouter/hosservice/SampleHospitalListFragment").navigation();
        if (hosCityListService != null) {
            final ISupportFragmentObservable cityFragment = hosCityListService.getCityFragment();
            final ISupportFragment hosListFragment = hosCityListService.getHosListFragment("");
            this.loadMultipleRootFragment(R.id.frame_content, 1, new ISupportFragment[]{cityFragment, hosListFragment});
            TextView cityNameView = (TextView)this.findViewById(this.rootView, R.id.txt_location);
            cityFragment.subscribe((o, arg) -> {
                this.mCityEntity = (ByhCommEvent.CityEntity)arg;
                String cityName = this.mCityEntity.getCityName();
                cityNameView.setText((CharSequence)cityName);
                this.mAreaCode = this.mCityEntity.getCode();
                this.isShowCityPage = true;
                this.showHideFragment(hosListFragment);
                EventBus.getDefault().post((Object)new ByhCommEvent.UpdateHosListEvent("", this.mAreaCode));
            });
            cityNameView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (YiyuanNameFragment.this.isShowCityPage) {
                        YiyuanNameFragment.this.showHideFragment((ISupportFragment)cityFragment);
                        YiyuanNameFragment.this.isShowCityPage = false;
                    } else {
                        YiyuanNameFragment.this.showHideFragment(hosListFragment);
                        YiyuanNameFragment.this.isShowCityPage = true;
                    }
                }
            });
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void receiveHosEntityEvent(ByhCommEvent.HosEntityEvent hosEntityEvent) {
        this.getActivity().finish();
    }

    @RequiresApi(api=3)
    private void initSearchHospital() {
        final EditText searchEdt = (EditText)this.findViewById(this.rootView, R.id.search_yiy);
        searchEdt.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    String searchParam = searchEdt.getText().toString().trim();
                    if (TextUtils.isEmpty((CharSequence)searchParam)) {
                        return true;
                    }
                    EventBus.getDefault().post((Object)new ByhCommEvent.UpdateHosListEvent(searchParam, YiyuanNameFragment.this.mAreaCode));
                }
                return false;
            }
        });
    }

    protected int getLayoutId() {
        return R.layout.yiyuuan_name_fragment;
    }
}

