/*
 * Decompiled with CFR 0.152.
 */
package com.byh.module.verlogin.present;

import android.content.Context;
import android.util.Log;
import com.blankj.utilcode.util.ToastUtils;
import com.byh.module.verlogin.R;
import com.byh.module.verlogin.entity.Login;
import com.byh.module.verlogin.intercept.RxLoginCommonObserver;
import com.byh.module.verlogin.module.IVerLoginModule;
import com.byh.module.verlogin.module.impl.VerLoginModule;
import com.byh.module.verlogin.present.PushBindPresenter;
import com.byh.module.verlogin.present.inter.IPushBindPresenter;
import com.byh.module.verlogin.utils.UpdateVerStatus;
import com.byh.module.verlogin.view.ILoginView;
import com.kangxin.common.base.ResponseBody;
import com.kangxin.common.byh.entity.response.LoginSuccess;
import com.kangxin.common.byh.event.Event;
import com.kangxin.common.byh.util.VertifyDataUtil;
import com.kangxin.common.byh.util.inter.IUpdateVerStatus;
import com.kangxin.common.util.StringsUtils;
import com.kangxin.common.widget.RxProgressObserver;
import io.reactivex.Observer;
import org.greenrobot.eventbus.EventBus;

public class VerLoginPresent {
    private static final String TAG = "VerLoginPresent";
    private ILoginView mLoginView;
    private IVerLoginModule mVerLoginModule;
    private IPushBindPresenter pushBindPresenter;
    private String mAuthKey;

    public VerLoginPresent(ILoginView mLoginView) {
        this.mLoginView = mLoginView;
        this.mVerLoginModule = new VerLoginModule();
        this.pushBindPresenter = new PushBindPresenter(mLoginView.injectContext());
    }

    public void loginApp(final Context context, Login login) {
        this.mVerLoginModule.userLogin(login).subscribe((Observer)new RxLoginCommonObserver<ResponseBody<LoginSuccess>>(){

            @Override
            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VertifyDataUtil.getInstance((Context)context).setLoginData((LoginSuccess)loginSuccessResponseBody.getResult());
                VerLoginPresent.this.updateUserInfo(context);
                UpdateVerStatus.getInstance().updateImToken(context);
                if (null != ((LoginSuccess)loginSuccessResponseBody.getData()).getDoctorLoginInfo()) {
                    VerLoginPresent.this.doctorzraddInfo(context, ((LoginSuccess)loginSuccessResponseBody.getResult()).getAccountStatus(), ((LoginSuccess)loginSuccessResponseBody.getData()).getDoctorLoginInfo().getDoctorId(), ((LoginSuccess)loginSuccessResponseBody.getData()).getDoctorLoginInfo().getOrganId());
                } else {
                    VerLoginPresent.this.mLoginView.loginOk(loginSuccessResponseBody);
                }
                super.onReqNext(loginSuccessResponseBody);
            }
        });
    }

    public void doctorzraddInfo(final Context context, final int status, String doctorId, String organId) {
        this.mVerLoginModule.doctorAddInfoCheck(doctorId, organId).subscribe((Observer)new RxProgressObserver<ResponseBody>(){

            public void onReqNext(ResponseBody loginSuccessResponseBody) {
                VertifyDataUtil.getInstance((Context)context).setInfoCheck(((Boolean)loginSuccessResponseBody.getData()).booleanValue());
                EventBus.getDefault().post((Object)new Event.infoCheck(((Boolean)loginSuccessResponseBody.getData()).booleanValue()));
                Log.e((String)"Event.infoCheck---1", (String)(loginSuccessResponseBody.getData() + ""));
                VerLoginPresent.this.mLoginView.getCheck(status);
            }
        });
    }

    private void updateUserInfo(Context context) {
        UpdateVerStatus.getInstance().updateDocDetailInfo(context, new IUpdateVerStatus.OnUpdateDocDetailInfoCallback(){

            public void updateDocDetailInfoOk() {
            }

            public void updateDocDetailInfoErr(String err) {
                ToastUtils.showShort((CharSequence)err);
            }
        });
    }

    public String getAuthKey() {
        return this.mAuthKey;
    }

    public void sentVerCode(String phoneNum) {
        this.mVerLoginModule.sendSmsAuthCode(phoneNum).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerLoginPresent.this.mAuthKey = ((LoginSuccess)loginSuccessResponseBody.getResult()).getAuthKey();
                ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.verlogin_fasongchenggong));
                VerLoginPresent.this.mLoginView.receiveVercode();
            }

            public void onReqErr(Throwable e) {
                ToastUtils.showLong((CharSequence)StringsUtils.getString((int)R.string.verlogin_fasongchenggong_shibai));
            }
        });
    }

    public void setPassword(final Context context, Login login) {
        this.mVerLoginModule.setPassword(login).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                LoginSuccess loginSuccess = (LoginSuccess)loginSuccessResponseBody.getResult();
                VertifyDataUtil.getInstance((Context)context).setToken(loginSuccess.getToken());
                VertifyDataUtil.getInstance((Context)context).setAccountStatus(loginSuccess.getAccountStatus());
                VertifyDataUtil.getInstance((Context)context).setAccountId(loginSuccess.getAccountId());
                VerLoginPresent.this.mLoginView.setPwdOk(loginSuccessResponseBody.getMsg());
            }
        });
    }

    public void updatePassword(Login login) {
        this.mVerLoginModule.updatePassword(login).subscribe((Observer)new RxProgressObserver<ResponseBody<LoginSuccess>>(){

            public void onReqNext(ResponseBody<LoginSuccess> loginSuccessResponseBody) {
                VerLoginPresent.this.mLoginView.setPwdOk(loginSuccessResponseBody.getMsg());
            }
        });
    }
}

