/*
 * Decompiled with CFR 0.152.
 */
package info.cd120.module_push;

import android.app.Notification;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.blankj.utilcode.util.LogUtils;
import com.kangxin.common.inter.IPushCallback;
import com.kangxin.common.util.DeviceIdUtil;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.message.IUmengRegisterCallback;
import com.umeng.message.PushAgent;
import com.umeng.message.UHandler;
import com.umeng.message.UmengMessageHandler;
import com.umeng.message.UmengNotificationClickHandler;
import com.umeng.message.entity.UMessage;
import info.cd120.module_push.NotificationHandler;
import info.cd120.module_push.SPUtils;
import java.util.HashMap;

public class PushManager {
    private static final String TAG = "PushManager";
    private static final String DEVICE_ID_SP_KEY = "umeng_device_id_sp_key";
    private HashMap<String, NotificationHandler> mHandler = new HashMap();
    private NotificationHandler mCommonHandler;
    private IPushCallback pushCallback;
    private PushAgent agent;

    public static void destory() {
    }

    public static void start() {
    }

    public static PushManager getInstance() {
        return Holder.instance;
    }

    public static String getDeviceId(Context context) {
        String devNum = SPUtils.get(context.getApplicationContext(), DEVICE_ID_SP_KEY, "");
        Log.i((String)TAG, (String)("getDeviceId: devid:" + devNum));
        if (!TextUtils.isEmpty((CharSequence)devNum)) {
            return devNum;
        }
        devNum = DeviceIdUtil.getDeviceId((Context)context);
        Log.i((String)TAG, (String)("getDeviceId: imei:" + devNum));
        return devNum;
    }

    public void registerPushCallback(IPushCallback pushCallback) {
        this.pushCallback = pushCallback;
    }

    public void registerHandler(String businessCode, NotificationHandler handler) {
        this.mHandler.put(businessCode, handler);
    }

    public void setMessageHandler(NotificationHandler handler) {
        this.mCommonHandler = handler;
    }

    public void initPush(Config config) {
        final Context applicationContext = config.context.getApplicationContext();
        UMConfigure.init((Context)applicationContext, (String)config.appKey, (String)"Umeng", (int)1, (String)config.messageSecret);
        this.agent = PushAgent.getInstance((Context)applicationContext);
        this.agent.register(new IUmengRegisterCallback(){

            public void onSuccess(String s) {
                SPUtils.put(applicationContext, PushManager.DEVICE_ID_SP_KEY, s);
            }

            public void onFailure(String s, String s1) {
            }
        });
        this.agent.setMessageHandler((UHandler)new UmengMessageHandler(){

            public Notification getNotification(Context context, UMessage uMessage) {
                Notification notification;
                LogUtils.i((Object[])new Object[]{"\u6536\u5230\u4e86\u6d88\u606f"});
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f=custom==>" + uMessage.custom));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f==extra=>" + uMessage.extra));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f==text=>" + uMessage.text));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f=ticker==>" + uMessage.ticker));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f=msg_id==>" + uMessage.msg_id));
                NotificationHandler notificationHandler = (NotificationHandler)PushManager.this.mHandler.get(uMessage.custom);
                try {
                    if (PushManager.this.pushCallback != null) {
                        PushManager.this.pushCallback.receiverMsg((Object)uMessage, context);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (notificationHandler != null) {
                    Notification notification2 = notificationHandler.getNotification(uMessage);
                    if (notification2 != null) {
                        return notification2;
                    }
                } else if (PushManager.this.mCommonHandler != null && (notification = PushManager.this.mCommonHandler.getNotification(uMessage)) != null) {
                    return notification;
                }
                return super.getNotification(context, uMessage);
            }
        });
        this.agent.setNotificationClickHandler((UHandler)new UmengNotificationClickHandler(){

            public void dealWithCustomAction(Context context, UMessage uMessage) {
                NotificationHandler notificationHandler = (NotificationHandler)PushManager.this.mHandler.get(uMessage.custom);
                if (PushManager.this.pushCallback != null) {
                    PushManager.this.pushCallback.receiverNotifyMsg((Object)uMessage, context);
                }
                if (notificationHandler != null) {
                    notificationHandler.dealWithCustomAction(uMessage);
                } else if (PushManager.this.mCommonHandler != null) {
                    PushManager.this.mCommonHandler.dealWithCustomAction(uMessage);
                }
            }

            public void launchApp(Context context, UMessage uMessage) {
                if (PushManager.this.pushCallback != null) {
                    boolean b = PushManager.this.pushCallback.receiverLaunchApp((Object)uMessage, context);
                    if (b) {
                        super.launchApp(context, uMessage);
                    }
                } else {
                    super.launchApp(context, uMessage);
                }
            }
        });
    }

    public static class Config {
        private Context context;
        private String appKey;
        private String messageSecret;

        public Config(Context context) {
            this.context = context;
        }

        public Config appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public Config messageSecret(String messageSecret) {
            this.messageSecret = messageSecret;
            return this;
        }
    }

    private static class Holder {
        private static PushManager instance = new PushManager();

        private Holder() {
        }
    }
}

