/*
 * Decompiled with CFR 0.152.
 */
package info.cd120.module_push.uMeng.push;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.blankj.utilcode.util.ProcessUtils;
import com.blankj.utilcode.util.Utils;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.message.IUmengRegisterCallback;
import com.umeng.message.PushAgent;
import org.android.agoo.huawei.HuaWeiRegister;
import org.android.agoo.mezu.MeizuRegister;
import org.android.agoo.oppo.OppoRegister;
import org.android.agoo.vivo.VivoRegister;
import org.android.agoo.xiaomi.MiPushRegistar;

class PushInitExecute {
    private static PushInitExecute execute;
    private final String TAG = "PushManager";
    private String channel = "PATEINT_ANDROID";
    private String deviceToken = "-1";
    private Application application;

    private PushInitExecute(Application application) {
        this.application = application;
    }

    static void inject(Application application) {
        execute = new PushInitExecute(application);
    }

    public static PushInitExecute getInstance() {
        return execute;
    }

    void initUMengServer(String uMengAppKey, String uMengSerect) {
        UMConfigure.setLogEnabled((boolean)false);
        this.getPushAgent().setNotificaitonOnForeground(true);
        UMConfigure.init((Context)this.application, (String)uMengAppKey, (String)this.channel, (int)1, (String)uMengSerect);
        this.getPushAgent().register(new IUmengRegisterCallback(){

            public void onSuccess(String s) {
                PushInitExecute.this.deviceToken = s;
                Log.i((String)"PushManager", (String)("onSuccess: " + s));
            }

            public void onFailure(String s, String s1) {
                Log.e((String)"PushManager", (String)("\u53cb\u76df\u521d\u59cb\u5316\u5931\u8d25: " + s + "," + s1));
            }
        });
    }

    void initXiaomiServer(String xiaomiId, String xiaomiKey) {
        if (ProcessUtils.isMainProcess()) {
            MiPushRegistar.register((Context)this.application, (String)xiaomiId, (String)xiaomiKey);
        }
    }

    void initHuaweiServer() {
        HuaWeiRegister.register((Application)this.application);
    }

    void initMeizuServer(String meizuAppId, String meizuAppKey) {
        MeizuRegister.register((Context)this.application, (String)meizuAppId, (String)meizuAppKey);
    }

    void initOppoServer(String oppoKey, String oppoSecret) {
        OppoRegister.register((Context)this.application, (String)oppoKey, (String)oppoSecret);
    }

    void initVivoServer() {
        VivoRegister.register((Context)this.application);
    }

    protected PushAgent getPushAgent() {
        return PushAgent.getInstance((Context)Utils.getApp());
    }

    protected String getDeviceToken() {
        return this.deviceToken;
    }
}

