/*
 * Decompiled with CFR 0.152.
 */
package info.cd120.module_push.uMeng.push.history;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import cn.finalteam.toolsfinal.BitmapUtils;
import com.blankj.utilcode.util.AppUtils;
import com.blankj.utilcode.util.Utils;

public class NotificationUtils {
    private static int id = 0;
    private Context context;
    private NotificationManager notificationManager = (NotificationManager)Utils.getApp().getSystemService("notification");

    @SuppressLint(value={"NewApi"})
    private NotificationUtils() {
        this.createNotificationChannel();
    }

    public static NotificationUtils getInstance() {
        return NotificationUtilsHolder.notificationUtils;
    }

    @RequiresApi(api=26)
    public void createNotificationChannel() {
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationChannel channel = new NotificationChannel("commonChannel", (CharSequence)"\u4e1a\u52a1\u901a\u77e5", 4);
            channel.enableLights(true);
            channel.setLightColor(-65536);
            channel.setShowBadge(true);
            channel.canShowBadge();
            channel.setBypassDnd(true);
            channel.setDescription(AppUtils.getAppName() + "\u901a\u77e5");
            channel.enableVibration(true);
            channel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            this.notificationManager.createNotificationChannel(channel);
        }
    }

    public void sendNotification(String title, String content, Intent intent) {
        PendingIntent pendingIntent = null;
        if (intent != null) {
            pendingIntent = PendingIntent.getActivity((Context)Utils.getApp(), (int)0, (Intent)intent, (int)0x10000000);
        }
        Notification notification = new NotificationCompat.Builder((Context)Utils.getApp(), "commonChannel").setContentTitle((CharSequence)title).setContentText((CharSequence)content).setTicker((CharSequence)title).setPriority(4).setLargeIcon(BitmapUtils.drawableToBitmap((Drawable)AppUtils.getAppIcon())).setDefaults(2).setWhen(System.currentTimeMillis()).setAutoCancel(true).setContentIntent(pendingIntent).build();
        this.notificationManager.notify(id++, notification);
    }

    private static class NotificationUtilsHolder {
        public static final NotificationUtils notificationUtils = new NotificationUtils();

        private NotificationUtilsHolder() {
        }
    }
}

