package com.kangxin.push;

import android.app.Notification;
import android.content.Context;
import android.text.TextUtils;

import com.kangxin.push.callback.IPushCallback;
import com.kangxin.push.callback.impl.UmengRegisterCallback;
import com.kangxin.push.config.Config;
import com.kangxin.push.utils.PushLogger;
import com.kangxin.push.utils.PushTokenSpUtils;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.message.PushAgent;
import com.umeng.message.UmengMessageHandler;
import com.umeng.message.UmengNotificationClickHandler;
import com.umeng.message.entity.UMessage;

public class PushManager {

    private IPushCallback pushCallback;

    public static PushManager getInstance() {
        return Holder.instance;
    }

    public static String getDeviceId(Context context, String defaultDeviceId) {
        String devNum = PushTokenSpUtils.get(context.getApplicationContext());
        PushLogger.i("deviceId:" + devNum);
        if (!TextUtils.isEmpty(devNum)) {
            return devNum;
        }
        devNum = defaultDeviceId;
        PushLogger.i("defaultDeviceId:" + devNum);
        return devNum;
    }

    public static void destroy() {
    }

    public static void start() {
    }

    public void registerPushCallback(IPushCallback pushCallback) {
        this.pushCallback = pushCallback;
    }

    public void initPush(Config config) {
        Context applicationContext = config.getContext().getApplicationContext();
        UMConfigure.init(applicationContext, config.getAppKey(), "Umeng", UMConfigure.DEVICE_TYPE_PHONE, config.getMessageSecret());
        PushAgent agent = PushAgent.getInstance(applicationContext);
        agent.register(new UmengRegisterCallback(applicationContext));
        agent.setMessageHandler(new UmengMessageHandler() {

            @Override
            public void dealWithNotificationMessage(Context context, UMessage uMessage) {
                if (pushCallback == null || !pushCallback.dealWithNotificationMessage(context, uMessage)) {
                    super.dealWithNotificationMessage(context, uMessage);
                }
            }

            @Override
            public Notification getNotification(Context context, UMessage uMessage) {
                PushLogger.i("收到了消息=custom==>" + uMessage.custom);
                PushLogger.i("收到了消息==extra=>" + uMessage.extra);
                PushLogger.i("收到了消息==text=>" + uMessage.text);
                PushLogger.i("收到了消息=ticker==>" + uMessage.ticker);
                PushLogger.i("收到了消息=msg_id==>" + uMessage.msg_id);
                if (pushCallback != null) {
                    pushCallback.receiverMsg(context, uMessage);
                }
                return super.getNotification(context, uMessage);
            }
        });
        agent.setNotificationClickHandler(new UmengNotificationClickHandler() {
            @Override
            public void launchApp(Context context, UMessage uMessage) {
                if (pushCallback == null || !pushCallback.receiverLaunchApp(context, uMessage)) {
                    super.launchApp(context, uMessage);
                }
            }

            @Override
            public void dealWithCustomAction(Context context, UMessage uMessage) {
                if (pushCallback != null) {
                    pushCallback.receiverNotifyMsg(context, uMessage);
                }
            }
        });
    }

    private static class Holder {
        private static PushManager instance = new PushManager();
    }
}
