package com.kangxin.push.callback;

import android.content.Context;

import com.umeng.message.entity.UMessage;

public interface IPushCallback {

    /**
     * 接受消息
     *
     * @param uMessage {@link UMessage}
     * @param context  {@link Context}
     */
    default void receiverMsg(Context context, UMessage uMessage) {

    }

    /**
     * 接受推送消息
     *
     * @param uMessage {@link UMessage}
     * @param context  {@link Context}
     */
    default void receiverNotifyMsg(Context context, UMessage uMessage) {
    }

    /**
     * 点击通知栏拦截 go_app
     *
     * @param uMessage {@link UMessage}
     * @param context  {@link Context}
     * @return true 拦截友盟自带的launchApp
     */
    default boolean receiverLaunchApp(Context context, UMessage uMessage) {
        return false;
    }

    /**
     * @param uMessage {@link UMessage}
     * @param context  {@link Context}
     * @return true 拦截友盟通知栏
     */
    default boolean dealWithNotificationMessage(Context context, UMessage uMessage) {
        return false;
    }

}
