package com.kangxin.push.db;

import com.kangxin.push.db.entity.PushEntity;

import java.util.List;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

public class PushDbCompat {

    public Flowable<List<PushEntity>> getPushAllList() {
        return PushDbManager.getInstance().pushDao().getPushs().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Flowable<List<PushEntity>> getUnreadPushList() {
        return PushDbManager.getInstance().pushDao().getUnreadPushList().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Flowable<List<PushEntity>> getPushListByUnBusType(String... unBusType) {
        return PushDbManager.getInstance().pushDao().getPushUnByBusinessType(unBusType).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Flowable<List<PushEntity>> getPushListByBusType(String busType) {
        return PushDbManager.getInstance().pushDao().getPushsByBusinessType(busType).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Observable readPush(String pushKey) {
        return Observable.create(emitter -> {
            PushDbManager.getInstance().pushDao().readPushByPushKey(pushKey);
            emitter.onNext(new Object());
        });
    }

    public Observable readAllPush() {
        return Observable.create(emitter -> {
            PushDbManager.getInstance().pushDao().readAllPush();
            emitter.onNext(new Object());
        }).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable readPushByBusType(String... busType) {
        return Observable.create(emitter -> {
            PushDbManager.getInstance().pushDao().readAllPush(busType);
            emitter.onNext(new Object());
        }).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable readPushUnBusType(String... busType) {
        return Observable.create(emitter -> {
            PushDbManager.getInstance().pushDao().readPushUnBusType(busType);
            emitter.onNext(new Object());
        }).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }

    public Observable clearPush() {
        return Observable.create(emitter -> {
            PushDbManager.getInstance().pushDao().clearPush();
            emitter.onNext(new Object());
        }).subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread());
    }
}
