package com.kangxin.push.db;

import android.content.Context;

import androidx.room.Room;

public class PushDbManager {

    private static PushDataBase instance;
    private static final String DB_NAME = "by_doctor";

    private PushDbManager() {
    }

    public static PushDataBase getInstance() {
        if (instance == null) {
            throw new RuntimeException("未初始化数据库,请调用 PushDbManager.init(context)");
        } else {
            return instance;
        }
    }

    public static void init(Context context) {
        if (instance == null) {
            instance = Room
                    .databaseBuilder(context, PushDataBase.class, DB_NAME)
                    .fallbackToDestructiveMigration()
                    .build();
        } else {
            throw new RuntimeException("不要初始化多次");
        }
    }

}
