package com.kangxin.push.db.dao;


import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.Query;

import com.kangxin.push.db.entity.PushEntity;

import java.util.List;

import io.reactivex.Flowable;

@Dao
public interface PushDao {

    /**
     * 获取所有推送数据
     */
    @Query("SELECT * FROM push2")
    Flowable<List<PushEntity>> getPushs();

    /**
     * 获取所有推送数据
     *
     * @param businessType 业务类型
     */
    @Query("SELECT * FROM push2 WHERE business_type=:businessType AND is_read!=1")
    Flowable<List<PushEntity>> getPushsByBusinessType(String businessType);

    /**
     * 更新所有字段为已读
     */
    @Query("UPDATE push2 SET is_read = :status WHERE business_type = :businessType1 AND business_type = :businessType2")
    void readAllPush(int businessType1, int businessType2, int status);

    /**
     * 更新所有字段为已读
     */
    @Query("UPDATE push2 SET is_read = :status WHERE business_type = :businessType1")
    void readAllPush(int businessType1, String status);

    /**
     * 获取所有推送数据，排除两种类型
     *
     * @param businessType1 业务类型
     */
    @Query("SELECT * FROM push2 WHERE business_type!=:businessType1 AND business_type!=:businessType2")
    Flowable<List<PushEntity>> getPushUnByBusinessType(Integer businessType1, Integer businessType2);

    /**
     * 某条数据是否已读
     *
     * @param pushKey pushkey
     */
    @Query("SELECT is_read FROM push2 WHERE pushKey=:pushKey")
    Flowable<Integer> isRead(String pushKey);

    /**
     * 通过获取单条push
     */
    @Query("SELECT * FROM push2 WHERE pushKey=:pushKey")
    Flowable<PushEntity> getPush(String pushKey);

    /**
     * 通过业务类型来获取push对象列表
     */
    @Query("SELECT * FROM push2 WHERE business_type=:businessType")
    Flowable<List<PushEntity>> getPushsByBussinessType(int businessType);

    /**
     * 通过业务类型来获取push对象列表最后一条
     */
    @Query("SELECT * FROM push2 WHERE business_type=:businessType ORDER BY pushKey DESC LIMIT 1")
    Flowable<PushEntity> getPushLastByBussinessType(int businessType);

    /**
     * 保存push信息
     */
    @Insert
    Long savePush(PushEntity pushEntity);

    /**
     * ReportDetailFragment
     * 清楚所有数据
     */
    @Query("delete from push2 ")
    void clearPush();

    /**
     * 删除pushkey为某条的记录
     */
    @Query("delete from push2 where pushKey = :pushKey")
    void clearPushByPushKey(String pushKey);

    /**
     * 获取未读推送列表
     */
    @Query("SELECT * FROM push2 WHERE is_read!=1")
    Flowable<List<PushEntity>> getUnreadPushList();

    /**
     * 阅读某条推送
     */
    @Query("UPDATE push2 SET is_read = 1 WHERE business_key = :pushKey ")
    void readPushByPushKey(String pushKey);

    /**
     * 阅读所有推送
     */
    @Query("UPDATE push2 SET is_read = 1")
    void readAllPush();

    /**
     * 阅读类型为int数组的所有推送
     */
    @Query("UPDATE push2 SET is_read = 1 WHERE business_type IN(:busType) ")
    void readAllPush(String[] busType);

    /**
     * 排除该类型之后，其他的都标记为已读
     */
    @Query("UPDATE push2 SET is_read = 1 WHERE business_type NOT IN(:busType)")
    void readPushUnBusType(String... busType);

    /**
     * 排除之外
     */
    @Query("SELECT * from push2 where business_type NOT IN (:unBusType)")
    Flowable<List<PushEntity>> getPushUnByBusinessType(String[] unBusType);

}
