package com.kangxin.push.db.entity;


import android.text.TextUtils;

import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;

import com.google.gson.Gson;
import com.umeng.message.entity.UMessage;

import org.jetbrains.annotations.NotNull;

import java.io.Serializable;
import java.util.Map;

@Entity(tableName = "push2")
public class PushEntity implements Serializable {

    /**
     * push唯一标识
     */
    @NonNull
    @PrimaryKey
    String pushKey = "";

    /**
     * 推送编码(标题标识)
     */
    @ColumnInfo(name = "push_code")
    String pushCode;

    @Ignore
    String followupPlanOrderDetailId;

    @Ignore
    String formName;

    @Ignore
    String id;

    @Ignore
    String actionCode;

    @Ignore
    String createTime;

    @Ignore
    String notifyType;

    @Ignore
    String sdkAccount;
    /**
     * 业务主键
     */
    @ColumnInfo(name = "business_key")
    Long businessKey;

    /**
     * 业务类别
     */
    @ColumnInfo(name = "business_type")
    String businessType;

    /**
     * 业务扩展字段
     */
    @ColumnInfo(name = "business_extend")
    String businessExtend;

    @Ignore
    String userId;
    /**
     * 推送显示内容
     */
    @ColumnInfo(name = "content")
    String content;

    /**
     * 标题
     */
    @ColumnInfo(name = "title")
    String title;

    @ColumnInfo(name = "is_read")
    Integer isRead = 0;

    public static PushEntity parse(UMessage msg) {
        PushEntity entity = new PushEntity();
        entity.setPushKey(msg.msg_id);
        Map<String, String> extra = msg.extra;

        if (extra != null) {
            PushOrderEntity pushOrderEntity = new Gson().fromJson(new Gson().toJson(extra), PushOrderEntity.class);
            entity.pushCode = pushOrderEntity.getPushCode();
            entity.pushKey = msg.msg_id;
            entity.businessType = pushOrderEntity.getPushCode();
            entity.businessExtend = pushOrderEntity.getOrderViewId();
            entity.sdkAccount = extra.get("sdkAccount");
            entity.followupPlanOrderDetailId = extra.get("followupPlanOrderDetailId");
            entity.formName = extra.get("formName");
            entity.actionCode = extra.get("actionCode");
            entity.id = extra.get("id");
            String userId = extra.get("userId");
            if (!TextUtils.isEmpty(userId)) {
                entity.userId = userId;
            }
            if (TextUtils.isEmpty(entity.pushCode)) {
                entity.pushCode = extra.get("businessCode");
                entity.businessType = extra.get("businessCode");
                entity.businessExtend = extra.get("orderId");
                entity.notifyType = extra.get("notifyType");
            }
        }
        entity.content = msg.text;
        entity.title = msg.ticker;
        return entity;
    }

    public String getSdkAccount() {
        return sdkAccount;
    }

    public void setSdkAccount(String sdkAccount) {
        this.sdkAccount = sdkAccount;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getNotifyType() {
        return notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    @NotNull
    public String getPushKey() {
        return pushKey;
    }

    public void setPushKey(@NotNull String pushKey) {
        this.pushKey = pushKey;
    }

    public String getPushCode() {
        return pushCode;
    }

    public void setPushCode(String pushCode) {
        this.pushCode = pushCode;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public Long getBusinessKey() {
        return businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public String getBusinessType() {
        return businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBusinessExtend() {
        return businessExtend;
    }

    public void setBusinessExtend(String businessExtend) {
        this.businessExtend = businessExtend;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getIsRead() {
        return isRead;
    }

    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }

    public String getFollowupPlanOrderDetailId() {
        return followupPlanOrderDetailId;
    }

    public void setFollowupPlanOrderDetailId(String followupPlanOrderDetailId) {
        this.followupPlanOrderDetailId = followupPlanOrderDetailId;
    }

    public String getFormName() {
        return formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getActionCode() {
        return actionCode;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    @NotNull
    @Override
    public String toString() {
        return "PushEntity{" +
                "pushKey='" + pushKey + '\'' +
                ", pushCode='" + pushCode + '\'' +
                ", followupPlanOrderDetailId='" + followupPlanOrderDetailId + '\'' +
                ", formName='" + formName + '\'' +
                ", id='" + id + '\'' +
                ", actionCode='" + actionCode + '\'' +
                ", createTime='" + createTime + '\'' +
                ", notifyType='" + notifyType + '\'' +
                ", sdkAccount='" + sdkAccount + '\'' +
                ", businessKey=" + businessKey +
                ", businessType='" + businessType + '\'' +
                ", businessExtend='" + businessExtend + '\'' +
                ", userId='" + userId + '\'' +
                ", content='" + content + '\'' +
                ", title='" + title + '\'' +
                ", isRead=" + isRead +
                '}';
    }
}
