package com.kangxin.push.db.helper;

import android.annotation.SuppressLint;

import androidx.annotation.Nullable;

import com.kangxin.push.db.PushDbCompat;
import com.kangxin.push.utils.PushLogger;

import java.util.Arrays;

@SuppressWarnings({"ResultOfMethodCallIgnored", "unchecked"})
@SuppressLint("CheckResult")
public class PushDbHelper {

    private PushDbCompat pushModule;
    @Nullable
    private IPushDbView iPushDbView;

    public PushDbHelper(@Nullable IPushDbView iPushDbView) {
        this.iPushDbView = iPushDbView;
        pushModule = new PushDbCompat();
    }

    /**
     * 通过推送类型获取列表
     */
    public void getPushListByUnBusType(String... busType) {
        pushModule
                .getPushListByUnBusType(busType)
                .subscribe(byPushEntities -> {
                    if (iPushDbView != null) {
                        iPushDbView.pushListByUnBusTypeSuccess(byPushEntities, busType);
                    }
                });
    }

    /**
     * 通过推送类型获取其他列表
     */
    public void getPushListByBusType(String busType) {
        pushModule
                .getPushListByBusType(busType)
                .subscribe(byPushEntities -> {
                    PushLogger.i("获取列表成功" + busType + "长度=" + byPushEntities.size());
                    if (iPushDbView != null) {
                        iPushDbView.pushListByBusTypeSuccess(byPushEntities, busType);
                    }
                });
    }

    /**
     * 通过类型已读推送
     */
    public void readPushByBusType(String... busType) {
        pushModule
                .readPushByBusType(busType)
                .subscribe(o -> {
                    PushLogger.i("阅读数据成功" + Arrays.toString(busType));
                    if (iPushDbView != null) {
                        iPushDbView.readPushByBusTypeSuccess();
                    }
                });
    }

    /**
     * 排除bustype之后，其他的都标记为已读
     */
    public void readPushUnBusType(String... busType) {
        pushModule
                .readPushUnBusType(busType)
                .subscribe(o -> {
                    PushLogger.i("通过类型阅读成功" + Arrays.toString(busType));
                    if (iPushDbView != null) {
                        iPushDbView.readPushUnBusTypeSuccess();
                    }
                });
    }
}
