package com.kangxin.push.utils;

import android.content.Context;
import android.content.SharedPreferences;

public final class PushTokenSpUtils {

    private static final String S_NAME = "info.cd120.module_push.sharedpreferences";
    private static final String DEVICE_ID_SP_KEY = "umeng_device_id_sp_key";

    public static void put(Context context, String content) {
        getEditor(context).putString(DEVICE_ID_SP_KEY, content).apply();
    }

    public static String get(Context context) {
        return getSharedPreferences(context).getString(DEVICE_ID_SP_KEY, "");
    }

    private static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences(S_NAME, Context.MODE_PRIVATE);
    }

    private static SharedPreferences.Editor getEditor(Context context) {
        return getSharedPreferences(context).edit();
    }

}
