/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.push;

import android.app.Notification;
import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.kangxin.push.NotificationHandler;
import com.kangxin.push.SPUtils;
import com.kangxin.push.config.Config;
import com.kangxin.push.config.IPushCallback;
import com.taobao.accs.ACCSClient;
import com.taobao.accs.AccsClientConfig;
import com.taobao.agoo.TaobaoRegister;
import com.umeng.commonsdk.UMConfigure;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.message.IUmengRegisterCallback;
import com.umeng.message.PushAgent;
import com.umeng.message.UmengMessageHandler;
import com.umeng.message.UmengNotificationClickHandler;
import com.umeng.message.api.UPushMessageHandler;
import com.umeng.message.api.UPushRegisterCallback;
import com.umeng.message.entity.UMessage;
import java.util.HashMap;

public class PushManager {
    private static final String TAG = "PushManager";
    private HashMap<String, NotificationHandler> mHandler = new HashMap();
    private NotificationHandler mCommonHandler;
    private IPushCallback pushCallback;
    private PushAgent agent;

    public static PushManager getInstance() {
        return Holder.instance;
    }

    public static String getDeviceId(Context context, String defaultDeviceId) {
        String devNum = SPUtils.get(context.getApplicationContext());
        Log.i((String)TAG, (String)("getDeviceId: devid:" + devNum));
        if (!TextUtils.isEmpty((CharSequence)devNum)) {
            return devNum;
        }
        devNum = defaultDeviceId;
        Log.i((String)TAG, (String)("getDeviceId: imei:" + devNum));
        return devNum;
    }

    public static void destroy() {
    }

    public static void start() {
    }

    public void registerPushCallback(IPushCallback pushCallback) {
        this.pushCallback = pushCallback;
    }

    public void registerHandler(String businessCode, NotificationHandler handler) {
        this.mHandler.put(businessCode, handler);
    }

    public void setMessageHandler(NotificationHandler handler) {
        this.mCommonHandler = handler;
    }

    public void initPush(Config config) {
        final Context applicationContext = config.getContext().getApplicationContext();
        UMConfigure.init((Context)applicationContext, (String)config.getAppKey(), (String)"Umeng", (int)1, (String)config.getMessageSecret());
        this.agent = PushAgent.getInstance((Context)applicationContext);
        this.agent.register((UPushRegisterCallback)new IUmengRegisterCallback(){

            public void onSuccess(String s) {
                Log.i((String)PushManager.TAG, (String)("onSuccess: device token:" + s));
                SPUtils.put(applicationContext, s);
            }

            public void onFailure(String s, String s1) {
                Log.i((String)PushManager.TAG, (String)("onFailure: desc1:" + s + ", desc2:" + s1));
            }
        });
        this.agent.setMessageHandler((UPushMessageHandler)new UmengMessageHandler(){

            public void dealWithNotificationMessage(Context context, UMessage uMessage) {
                if (PushManager.this.pushCallback != null) {
                    if (!PushManager.this.pushCallback.dealWithNotificationMessage(context, uMessage)) {
                        super.dealWithNotificationMessage(context, uMessage);
                    }
                } else {
                    super.dealWithNotificationMessage(context, uMessage);
                }
            }

            public Notification getNotification(Context context, UMessage uMessage) {
                Notification notification;
                Log.i((String)PushManager.TAG, (String)"\u6536\u5230\u4e86\u6d88\u606f");
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f=custom==>" + uMessage.custom));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f==extra=>" + uMessage.extra));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f==text=>" + uMessage.text));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f=ticker==>" + uMessage.ticker));
                Log.i((String)PushManager.TAG, (String)("getNotification: \u6536\u5230\u4e86\u6d88\u606f=msg_id==>" + uMessage.msg_id));
                NotificationHandler notificationHandler = (NotificationHandler)PushManager.this.mHandler.get(uMessage.custom);
                try {
                    if (PushManager.this.pushCallback != null) {
                        PushManager.this.pushCallback.receiverMsg(uMessage, context);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (notificationHandler != null) {
                    Notification notification2 = notificationHandler.getNotification(uMessage);
                    if (notification2 != null) {
                        return notification2;
                    }
                } else if (PushManager.this.mCommonHandler != null && (notification = PushManager.this.mCommonHandler.getNotification(uMessage)) != null) {
                    return notification;
                }
                return super.getNotification(context, uMessage);
            }
        });
        this.agent.setNotificationClickHandler((UPushMessageHandler)new UmengNotificationClickHandler(){

            public void dealWithCustomAction(Context context, UMessage uMessage) {
                NotificationHandler notificationHandler = (NotificationHandler)PushManager.this.mHandler.get(uMessage.custom);
                if (PushManager.this.pushCallback != null) {
                    PushManager.this.pushCallback.receiverNotifyMsg(uMessage, context);
                }
                if (notificationHandler != null) {
                    notificationHandler.dealWithCustomAction(uMessage);
                } else if (PushManager.this.mCommonHandler != null) {
                    PushManager.this.mCommonHandler.dealWithCustomAction(uMessage);
                }
            }

            public void launchApp(Context context, UMessage uMessage) {
                if (PushManager.this.pushCallback != null) {
                    boolean b = PushManager.this.pushCallback.receiverLaunchApp(uMessage, context);
                    if (b) {
                        super.launchApp(context, uMessage);
                    }
                } else {
                    super.launchApp(context, uMessage);
                }
            }
        });
    }

    public void preInit(Context context, Config config) {
        try {
            AccsClientConfig.Builder builder = new AccsClientConfig.Builder();
            builder.setAppKey("umeng:" + config.getAppKey());
            builder.setAppSecret(config.getMessageSecret());
            builder.setTag("default");
            ACCSClient.init((Context)context, (AccsClientConfig)builder.build());
            TaobaoRegister.setAccsConfigTag((Context)context, (String)"default");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        UMConfigure.preInit((Context)context, (String)config.getAppKey(), (String)"Umeng");
        if (!PushManager.isMainProcess(context)) {
            this.initPush(config);
        }
    }

    public static boolean isMainProcess(Context context) {
        return UMUtils.isMainProgress((Context)context);
    }

    private static class Holder {
        private static PushManager instance = new PushManager();

        private Holder() {
        }
    }
}

