/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.push.db.entity;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.Ignore;
import androidx.room.PrimaryKey;
import com.google.gson.Gson;
import com.kangxin.push.db.entity.PushOrderEntity;
import com.umeng.message.entity.UMessage;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Entity(tableName="push2")
public class PushEntity
implements Serializable {
    @NonNull
    @PrimaryKey
    String pushKey = "";
    @ColumnInfo(name="push_code")
    String pushCode;
    @Ignore
    String followupPlanOrderDetailId;
    @Ignore
    String formName;
    @Ignore
    String id;
    @Ignore
    String actionCode;
    @Ignore
    String createTime;
    @Ignore
    String notifyType;
    @Ignore
    String sdkAccount;
    @ColumnInfo(name="business_key")
    Long businessKey;
    @ColumnInfo(name="business_type")
    String businessType;
    @ColumnInfo(name="business_extend")
    String businessExtend;
    @Ignore
    String userId;
    @ColumnInfo(name="content")
    String content;
    @ColumnInfo(name="title")
    String title;
    @ColumnInfo(name="is_read")
    Integer isRead = 0;

    public static PushEntity parse(UMessage msg) {
        PushEntity entity = new PushEntity();
        entity.setPushKey(msg.msg_id);
        Map extra = msg.extra;
        if (extra != null) {
            PushOrderEntity pushOrderEntity = (PushOrderEntity)new Gson().fromJson(new Gson().toJson((Object)extra), PushOrderEntity.class);
            entity.pushCode = pushOrderEntity.getPushCode();
            entity.pushKey = msg.msg_id;
            entity.businessType = pushOrderEntity.getPushCode();
            entity.businessExtend = pushOrderEntity.getOrderViewId();
            entity.sdkAccount = (String)extra.get("sdkAccount");
            entity.followupPlanOrderDetailId = (String)extra.get("followupPlanOrderDetailId");
            entity.formName = (String)extra.get("formName");
            entity.actionCode = (String)extra.get("actionCode");
            entity.id = (String)extra.get("id");
            String userId = (String)extra.get("userId");
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                entity.userId = userId;
            }
            if (TextUtils.isEmpty((CharSequence)entity.pushCode)) {
                entity.pushCode = (String)extra.get("businessCode");
                entity.businessType = (String)extra.get("businessCode");
                entity.businessExtend = (String)extra.get("orderId");
                entity.notifyType = (String)extra.get("notifyType");
            }
        }
        entity.content = msg.text;
        entity.title = msg.ticker;
        return entity;
    }

    public String getSdkAccount() {
        return this.sdkAccount;
    }

    public void setSdkAccount(String sdkAccount) {
        this.sdkAccount = sdkAccount;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    @NotNull
    public String getPushKey() {
        return this.pushKey;
    }

    public void setPushKey(@NotNull String pushKey) {
        this.pushKey = pushKey;
    }

    public String getPushCode() {
        return this.pushCode;
    }

    public void setPushCode(String pushCode) {
        this.pushCode = pushCode;
    }

    public String getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public Long getBusinessKey() {
        return this.businessKey;
    }

    public void setBusinessKey(Long businessKey) {
        this.businessKey = businessKey;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public String getBusinessExtend() {
        return this.businessExtend;
    }

    public void setBusinessExtend(String businessExtend) {
        this.businessExtend = businessExtend;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getIsRead() {
        return this.isRead;
    }

    public void setIsRead(Integer isRead) {
        this.isRead = isRead;
    }

    public String getFollowupPlanOrderDetailId() {
        return this.followupPlanOrderDetailId;
    }

    public void setFollowupPlanOrderDetailId(String followupPlanOrderDetailId) {
        this.followupPlanOrderDetailId = followupPlanOrderDetailId;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getActionCode() {
        return this.actionCode;
    }

    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    @NotNull
    public String toString() {
        return "PushEntity{pushKey='" + this.pushKey + '\'' + ", pushCode='" + this.pushCode + '\'' + ", followupPlanOrderDetailId='" + this.followupPlanOrderDetailId + '\'' + ", formName='" + this.formName + '\'' + ", id='" + this.id + '\'' + ", actionCode='" + this.actionCode + '\'' + ", createTime='" + this.createTime + '\'' + ", notifyType='" + this.notifyType + '\'' + ", sdkAccount='" + this.sdkAccount + '\'' + ", businessKey=" + this.businessKey + ", businessType='" + this.businessType + '\'' + ", businessExtend='" + this.businessExtend + '\'' + ", userId='" + this.userId + '\'' + ", content='" + this.content + '\'' + ", title='" + this.title + '\'' + ", isRead=" + this.isRead + '}';
    }
}

