/*
 * Decompiled with CFR 0.152.
 */
package com.kangxin.push.db.helper;

import android.annotation.SuppressLint;
import androidx.annotation.Nullable;
import com.kangxin.push.db.PushDbCompat;
import com.kangxin.push.db.entity.PushEntity;
import com.kangxin.push.db.helper.IPushDbView;
import com.kangxin.push.utils.PushLogger;
import java.util.Arrays;
import java.util.List;

@SuppressLint(value={"CheckResult"})
public class PushDbHelper {
    private PushDbCompat pushModule;
    @Nullable
    private IPushDbView iPushDbView;

    public PushDbHelper(@Nullable IPushDbView iPushDbView) {
        this.iPushDbView = iPushDbView;
        this.pushModule = new PushDbCompat();
    }

    public void getPushListByUnBusType(String ... busType) {
        this.pushModule.getPushListByUnBusType(busType).subscribe(byPushEntities -> {
            if (this.iPushDbView != null) {
                this.iPushDbView.pushListByUnBusTypeSuccess((List<PushEntity>)byPushEntities, busType);
            }
        });
    }

    public void getPushListByBusType(String busType) {
        this.pushModule.getPushListByBusType(busType).subscribe(byPushEntities -> {
            PushLogger.i("\u83b7\u53d6\u5217\u8868\u6210\u529f" + busType + "\u957f\u5ea6=" + byPushEntities.size());
            if (this.iPushDbView != null) {
                this.iPushDbView.pushListByBusTypeSuccess((List<PushEntity>)byPushEntities, busType);
            }
        });
    }

    public void readPushByBusType(String ... busType) {
        this.pushModule.readPushByBusType(busType).subscribe(o -> {
            PushLogger.i("\u9605\u8bfb\u6570\u636e\u6210\u529f" + Arrays.toString(busType));
            if (this.iPushDbView != null) {
                this.iPushDbView.readPushByBusTypeSuccess();
            }
        });
    }

    public void readPushUnBusType(String ... busType) {
        this.pushModule.readPushUnBusType(busType).subscribe(o -> {
            PushLogger.i("\u901a\u8fc7\u7c7b\u578b\u9605\u8bfb\u6210\u529f" + Arrays.toString(busType));
            if (this.iPushDbView != null) {
                this.iPushDbView.readPushUnBusTypeSuccess();
            }
        });
    }
}

