/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import android.content.res.Resources;
import android.view.KeyEvent;
import android.widget.EditText;
import io.rong.common.RLog;
import io.rong.imkit.IExtensionModule;
import io.rong.imkit.RongExtension;
import io.rong.imkit.emoticon.EmojiTab;
import io.rong.imkit.emoticon.IEmojiItemClickListener;
import io.rong.imkit.emoticon.IEmoticonTab;
import io.rong.imkit.manager.InternalModuleManager;
import io.rong.imkit.plugin.CombineLocationPlugin;
import io.rong.imkit.plugin.DefaultLocationPlugin;
import io.rong.imkit.plugin.IPluginModule;
import io.rong.imkit.plugin.ImagePlugin;
import io.rong.imkit.widget.provider.FilePlugin;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class DefaultExtensionModule
implements IExtensionModule {
    private static final String TAG = DefaultExtensionModule.class.getSimpleName();
    private EditText mEditText;
    private Stack<EditText> stack;
    private String[] types = null;

    public DefaultExtensionModule(Context context) {
        Resources resources = context.getResources();
        try {
            this.types = resources.getStringArray(resources.getIdentifier("rc_realtime_support_conversation_types", "array", context.getPackageName()));
        }
        catch (Resources.NotFoundException e) {
            RLog.i((String)TAG, (String)"not config rc_realtime_support_conversation_types in rc_config.xml");
        }
    }

    public DefaultExtensionModule() {
    }

    @Override
    public void onInit(String appKey) {
        this.stack = new Stack();
    }

    @Override
    public void onConnect(String token) {
    }

    @Override
    public void onAttachedToExtension(RongExtension extension) {
        this.mEditText = extension.getInputEditText();
        RLog.i((String)TAG, (String)("attach " + this.stack.size()));
        this.stack.push(this.mEditText);
    }

    @Override
    public void onDetachedFromExtension() {
        RLog.i((String)TAG, (String)("detach " + this.stack.size()));
        if (this.stack.size() > 0) {
            this.stack.pop();
            this.mEditText = this.stack.size() > 0 ? this.stack.peek() : null;
        }
    }

    @Override
    public void onReceivedMessage(Message message) {
    }

    @Override
    public List<IPluginModule> getPluginModules(Conversation.ConversationType conversationType) {
        ArrayList<IPluginModule> pluginModuleList = new ArrayList<IPluginModule>();
        pluginModuleList.add(new ImagePlugin());
        try {
            String clsName = "com.amap.api.netlocation.AMapNetworkLocationClient";
            Class<?> locationCls = Class.forName(clsName);
            if (locationCls != null) {
                CombineLocationPlugin combineLocation = new CombineLocationPlugin();
                DefaultLocationPlugin locationPlugin = new DefaultLocationPlugin();
                boolean typesDefined = false;
                if (this.types != null && this.types.length > 0) {
                    for (String type : this.types) {
                        if (!conversationType.getName().equals(type)) continue;
                        typesDefined = true;
                        break;
                    }
                }
                if (typesDefined) {
                    pluginModuleList.add(combineLocation);
                } else if (this.types == null && conversationType.equals((Object)Conversation.ConversationType.PRIVATE)) {
                    pluginModuleList.add(combineLocation);
                } else {
                    pluginModuleList.add(locationPlugin);
                }
            }
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Not include AMap");
            RLog.e((String)TAG, (String)"getPluginModules", (Throwable)e);
        }
        if (conversationType.equals((Object)Conversation.ConversationType.GROUP) || conversationType.equals((Object)Conversation.ConversationType.DISCUSSION) || conversationType.equals((Object)Conversation.ConversationType.PRIVATE)) {
            pluginModuleList.addAll(InternalModuleManager.getInstance().getInternalPlugins(conversationType));
        }
        pluginModuleList.add(new FilePlugin());
        return pluginModuleList;
    }

    @Override
    public List<IEmoticonTab> getEmoticonTabs() {
        EmojiTab emojiTab = new EmojiTab();
        emojiTab.setOnItemClickListener(new IEmojiItemClickListener(){

            @Override
            public void onEmojiClick(String emoji) {
                int start = DefaultExtensionModule.this.mEditText.getSelectionStart();
                DefaultExtensionModule.this.mEditText.getText().insert(start, (CharSequence)emoji);
            }

            @Override
            public void onDeleteClick() {
                DefaultExtensionModule.this.mEditText.dispatchKeyEvent(new KeyEvent(0, 67));
            }
        });
        ArrayList<IEmoticonTab> list = new ArrayList<IEmoticonTab>();
        list.add(emojiTab);
        return list;
    }

    @Override
    public void onDisconnect() {
    }
}

