/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import io.rong.imkit.utilities.LangUtils;
import io.rong.imlib.RongIMClient;
import java.util.Locale;

public class RongConfigurationManager {
    private static String RONG_CONFIG = "RongKitConfiguration";
    private static String FILE_MAX_SIZE = "FileMaxSize";
    private static boolean isInit = false;

    private RongConfigurationManager() {
    }

    public static RongConfigurationManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public static void init(Context context) {
        if (!isInit) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.LOCALE_CHANGED");
            context.registerReceiver((BroadcastReceiver)new SystemConfigurationChangedReceiver(), filter);
            LangUtils.RCLocale locale = RongConfigurationManager.getInstance().getAppLocale(context);
            RongConfigurationManager.getInstance().switchLocale(locale, context);
            isInit = true;
        }
    }

    public void setFileMaxSize(Context context, int size) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(RONG_CONFIG, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putInt(FILE_MAX_SIZE, size).apply();
    }

    public int getFileMaxSize(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(RONG_CONFIG, 0);
        return sharedPreferences.getInt(FILE_MAX_SIZE, 100);
    }

    public void switchLocale(LangUtils.RCLocale locale, Context context) {
        Resources resources = context.getResources();
        Configuration config = resources.getConfiguration();
        config.locale = locale.toLocale();
        if (Build.VERSION.SDK_INT < 24) {
            context.getResources().updateConfiguration(config, resources.getDisplayMetrics());
        }
        LangUtils.saveLocale(context, locale);
    }

    public Context getConfigurationContext(Context context) {
        return LangUtils.getConfigurationContext(context);
    }

    public LangUtils.RCLocale getAppLocale(Context context) {
        return LangUtils.getAppLocale(context);
    }

    public Locale getSystemLocale() {
        return LangUtils.getSystemLocale();
    }

    public RongIMClient.PushLanguage getPushLanguage(Context context) {
        return LangUtils.getPushLanguage(context);
    }

    public void setPushLanguage(Context context, RongIMClient.PushLanguage pushLanguage) {
        LangUtils.setPushLanguage(context, pushLanguage);
    }

    private static class SystemConfigurationChangedReceiver
    extends BroadcastReceiver {
        private SystemConfigurationChangedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.LOCALE_CHANGED".equals(intent.getAction())) {
                LangUtils.setSystemLocale(Locale.getDefault());
                LangUtils.RCLocale appLocale = LangUtils.getAppLocale(context);
                Locale systemLocale = LangUtils.getSystemLocale();
                if (!appLocale.toLocale().equals(systemLocale)) {
                    RongConfigurationManager.getInstance().switchLocale(appLocale, context);
                }
            }
        }
    }

    private static class SingletonHolder {
        static RongConfigurationManager sInstance = new RongConfigurationManager();

        private SingletonHolder() {
        }
    }
}

