/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit;

import android.content.Context;
import io.rong.common.RLog;
import io.rong.imkit.IExtensionModule;
import io.rong.imkit.IExtensionProxy;
import io.rong.imkit.emoticon.AndroidEmoji;
import io.rong.imkit.utilities.RongUtils;
import io.rong.imlib.model.Message;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RongExtensionManager {
    private static final String TAG = "RongExtensionManager";
    private static String mAppKey;
    private static List<IExtensionModule> mExtModules;
    private static final String DEFAULT_REDPACKET = "com.jrmf360.rylib.modules.JrmfExtensionModule";
    private static final String DEFAULT_BQMM = "com.melink.bqmmplugin.rc.BQMMExtensionModule";
    private static final String DEFAULT_RC_STICKER = "io.rong.sticker.StickerExtensionModule";
    private static IExtensionProxy extensionProxy;

    private RongExtensionManager() {
        if (mExtModules != null) {
            try {
                Class<?> cls = Class.forName(DEFAULT_REDPACKET);
                Constructor<?> constructor = cls.getConstructor(new Class[0]);
                IExtensionModule jrmf = (IExtensionModule)constructor.newInstance(new Object[0]);
                RLog.i((String)TAG, (String)("add module " + jrmf.getClass().getSimpleName()));
                mExtModules.add(jrmf);
                jrmf.onInit(mAppKey);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.checkBQMM();
            this.checkRCBQ();
        }
    }

    public static RongExtensionManager getInstance() {
        return SingletonHolder.sInstance;
    }

    static void init(Context context, String appKey) {
        RLog.d((String)TAG, (String)"init");
        AndroidEmoji.init(context);
        RongUtils.init(context);
        mAppKey = appKey;
    }

    public static void setExtensionProxy(IExtensionProxy proxy) {
        extensionProxy = proxy;
    }

    static IExtensionProxy getExtensionProxy() {
        return extensionProxy;
    }

    public void registerExtensionModule(IExtensionModule extensionModule) {
        if (mExtModules == null) {
            RLog.e((String)TAG, (String)"Not init in the main process.");
            return;
        }
        if (extensionModule == null || mExtModules.contains(extensionModule)) {
            RLog.e((String)TAG, (String)"Illegal extensionModule.");
            return;
        }
        RLog.i((String)TAG, (String)("registerExtensionModule " + extensionModule.getClass().getSimpleName()));
        if (mExtModules.size() > 0 && (mExtModules.get(0).getClass().getCanonicalName().equals(DEFAULT_REDPACKET) || mExtModules.get(0).getClass().getCanonicalName().equals(DEFAULT_BQMM))) {
            mExtModules.add(0, extensionModule);
        } else {
            mExtModules.add(extensionModule);
        }
        extensionModule.onInit(mAppKey);
    }

    public void registerExtensionModule(int index, IExtensionModule extensionModule) {
        if (mExtModules == null) {
            RLog.e((String)TAG, (String)"Not init in the main process.");
            return;
        }
        if (extensionModule == null || mExtModules.contains(extensionModule)) {
            RLog.e((String)TAG, (String)"Illegal extensionModule.");
            return;
        }
        RLog.i((String)TAG, (String)("registerExtensionModule " + extensionModule.getClass().getSimpleName()));
        mExtModules.add(index, extensionModule);
        extensionModule.onInit(mAppKey);
    }

    public void addExtensionModule(IExtensionModule extensionModule) {
        if (mExtModules == null) {
            RLog.e((String)TAG, (String)"Not init in the main process.");
            return;
        }
        if (extensionModule == null || mExtModules.contains(extensionModule)) {
            RLog.e((String)TAG, (String)"Illegal extensionModule.");
            return;
        }
        RLog.i((String)TAG, (String)("addExtensionModule " + extensionModule.getClass().getSimpleName()));
        mExtModules.add(extensionModule);
    }

    public void unregisterExtensionModule(IExtensionModule extensionModule) {
        if (mExtModules == null) {
            RLog.e((String)TAG, (String)"Not init in the main process.");
            return;
        }
        if (extensionModule == null || !mExtModules.contains(extensionModule)) {
            RLog.e((String)TAG, (String)"Illegal extensionModule.");
            return;
        }
        RLog.i((String)TAG, (String)("unregisterExtensionModule " + extensionModule.getClass().getSimpleName()));
        Iterator<IExtensionModule> iterator = mExtModules.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(extensionModule)) continue;
            iterator.remove();
        }
    }

    public List<IExtensionModule> getExtensionModules() {
        return mExtModules;
    }

    void connect(String token) {
        if (mExtModules == null) {
            return;
        }
        for (IExtensionModule extensionModule : mExtModules) {
            extensionModule.onConnect(token);
        }
    }

    void disconnect() {
        if (mExtModules == null) {
            return;
        }
        for (IExtensionModule extensionModule : mExtModules) {
            extensionModule.onDisconnect();
        }
    }

    void onReceivedMessage(Message message) {
        for (IExtensionModule extensionModule : mExtModules) {
            extensionModule.onReceivedMessage(message);
        }
    }

    private void checkBQMM() {
        try {
            Class<?> cls = Class.forName(DEFAULT_BQMM);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            IExtensionModule bqmm = (IExtensionModule)constructor.newInstance(new Object[0]);
            RLog.i((String)TAG, (String)("add module " + bqmm.getClass().getSimpleName()));
            mExtModules.add(bqmm);
            bqmm.onInit(mAppKey);
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Can't find com.melink.bqmmplugin.rc.BQMMExtensionModule");
        }
    }

    private void checkRCBQ() {
        try {
            Class<?> cls = Class.forName(DEFAULT_RC_STICKER);
            Constructor<?> constructor = cls.getConstructor(new Class[0]);
            IExtensionModule rcbq = (IExtensionModule)constructor.newInstance(new Object[0]);
            RLog.i((String)TAG, (String)("add module " + rcbq.getClass().getSimpleName()));
            mExtModules.add(rcbq);
            rcbq.onInit(mAppKey);
        }
        catch (Exception e) {
            RLog.i((String)TAG, (String)"Can't find io.rong.sticker.StickerExtensionModule");
        }
    }

    static {
        mExtModules = new ArrayList<IExtensionModule>();
    }

    private static class SingletonHolder {
        static RongExtensionManager sInstance = new RongExtensionManager();

        private SingletonHolder() {
        }
    }
}

