/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.actions;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import io.rong.imkit.actions.ClickImageView;
import io.rong.imkit.actions.IClickActions;
import java.util.List;

public class MoreActionLayout
extends ViewGroup {
    private Context context;
    private Fragment fragment;
    private List<IClickActions> clickActions;

    public MoreActionLayout(Context context) {
        super(context);
        this.context = context;
    }

    public MoreActionLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int totalWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int childWidth = 0;
        if (this.getChildCount() > 0) {
            childWidth = totalWidth / this.getChildCount();
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
            View childView = this.getChildAt(i);
            childView.measure(childWidthSpec, heightMeasureSpec);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int total = this.getMeasuredWidth();
        int height = this.getMeasuredHeight();
        int width = 0;
        if (this.getChildCount() > 0) {
            width = total / this.getChildCount();
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            child.layout(i * width, 0, (i + 1) * width, height);
        }
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    public void addActions(List<IClickActions> actions) {
        this.clickActions = actions;
        if (actions != null && actions.size() > 0) {
            for (int i = 0; i < actions.size(); ++i) {
                final IClickActions action = actions.get(i);
                ClickImageView view = new ClickImageView(this.context);
                view.setImageDrawable(actions.get(i).obtainDrawable(this.context));
                view.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        action.onClick(MoreActionLayout.this.fragment);
                    }
                });
                this.addView((View)view, i);
            }
            this.invalidate();
        }
    }

    public void refreshView(boolean enable) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ClickImageView view = (ClickImageView)this.getChildAt(i);
            view.setEnable(enable);
        }
    }
}

