/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import io.rong.imkit.R;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.fragment.DispatchResultFragment;
import io.rong.imkit.model.Event;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imkit.utilities.OptionsPopupDialog;
import io.rong.imkit.widget.AsyncImageView;
import io.rong.imkit.widget.adapter.BaseAdapter;
import io.rong.imlib.RongIMClient;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.PublicServiceProfile;
import io.rong.imlib.model.PublicServiceProfileList;

public class PublicServiceSubscribeListFragment
extends DispatchResultFragment {
    private ListView mListView;
    private PublicServiceListAdapter mAdapter;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.rc_fr_public_service_sub_list, container, false);
        return view;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.mListView = (ListView)view.findViewById(R.id.rc_list);
        this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                PublicServiceProfile info = PublicServiceSubscribeListFragment.this.mAdapter.getItem(position);
                RongIM.getInstance().startConversation((Context)PublicServiceSubscribeListFragment.this.getActivity(), info.getConversationType(), info.getTargetId(), info.getName());
            }
        });
        this.mListView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, final int position, long id2) {
                String[] item = new String[1];
                final PublicServiceProfile info = PublicServiceSubscribeListFragment.this.mAdapter.getItem(position);
                if (info.getConversationType() == Conversation.ConversationType.PUBLIC_SERVICE) {
                    item[0] = PublicServiceSubscribeListFragment.this.getActivity().getString(R.string.rc_pub_service_info_unfollow);
                    OptionsPopupDialog.newInstance(view.getContext(), item).setOptionsPopupDialogListener(new OptionsPopupDialog.OnOptionsItemClickedListener(){

                        @Override
                        public void onOptionsItemClicked(int which) {
                            Conversation.PublicServiceType publicServiceType = null;
                            if (info.getConversationType() == Conversation.ConversationType.APP_PUBLIC_SERVICE) {
                                publicServiceType = Conversation.PublicServiceType.APP_PUBLIC_SERVICE;
                            } else if (info.getConversationType() == Conversation.ConversationType.PUBLIC_SERVICE) {
                                publicServiceType = Conversation.PublicServiceType.PUBLIC_SERVICE;
                            } else {
                                System.err.print("the public service type is error!!");
                            }
                            RongIMClient.getInstance().unsubscribePublicService(publicServiceType, info.getTargetId(), new RongIMClient.OperationCallback(){

                                public void onSuccess() {
                                    PublicServiceSubscribeListFragment.this.mAdapter.remove(position);
                                    PublicServiceSubscribeListFragment.this.mAdapter.notifyDataSetChanged();
                                }

                                public void onError(RongIMClient.ErrorCode errorCode) {
                                }
                            });
                        }
                    }).show();
                }
                return true;
            }
        });
        this.mAdapter = new PublicServiceListAdapter((Context)this.getActivity());
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.getDBData();
        RongContext.getInstance().getEventBus().register((Object)this);
    }

    private void getDBData() {
        RongIM.getInstance().getPublicServiceList(new RongIMClient.ResultCallback<PublicServiceProfileList>(){

            public void onSuccess(PublicServiceProfileList infoList) {
                for (PublicServiceProfile info : infoList.getPublicServiceData()) {
                    RongUserInfoManager.getInstance().setPublicServiceProfile(info);
                }
                PublicServiceSubscribeListFragment.this.mAdapter.clear();
                PublicServiceSubscribeListFragment.this.mAdapter.addCollection(infoList.getPublicServiceData());
                PublicServiceSubscribeListFragment.this.mAdapter.notifyDataSetChanged();
            }

            public void onError(RongIMClient.ErrorCode e) {
            }
        });
    }

    @Override
    protected void initFragment(Uri uri) {
    }

    @Override
    public boolean handleMessage(Message msg) {
        return false;
    }

    public void onEvent(Event.PublicServiceFollowableEvent event) {
        if (event != null) {
            this.getDBData();
        }
    }

    public void onDestroyView() {
        RongContext.getInstance().getEventBus().unregister((Object)this);
        super.onDestroyView();
    }

    private class PublicServiceListAdapter
    extends BaseAdapter<PublicServiceProfile> {
        LayoutInflater mInflater;

        public PublicServiceListAdapter(Context context) {
            this.mInflater = LayoutInflater.from((Context)context);
        }

        @Override
        protected View newView(Context context, int position, ViewGroup group) {
            View view = this.mInflater.inflate(R.layout.rc_item_public_service_list, null);
            ViewHolder viewHolder = new ViewHolder();
            viewHolder.portrait = (AsyncImageView)view.findViewById(R.id.portrait);
            viewHolder.name = (TextView)view.findViewById(R.id.name);
            viewHolder.introduction = (TextView)view.findViewById(R.id.introduction);
            view.setTag((Object)viewHolder);
            return view;
        }

        @Override
        protected void bindView(View v, int position, PublicServiceProfile data) {
            ViewHolder viewHolder = (ViewHolder)v.getTag();
            if (data != null) {
                viewHolder.portrait.setResource(data.getPortraitUri());
                viewHolder.name.setText((CharSequence)data.getName());
                viewHolder.introduction.setText((CharSequence)data.getIntroduction());
            }
        }

        @Override
        public int getCount() {
            return super.getCount();
        }

        @Override
        public PublicServiceProfile getItem(int position) {
            return (PublicServiceProfile)super.getItem(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        class ViewHolder {
            AsyncImageView portrait;
            TextView name;
            TextView introduction;

            ViewHolder() {
            }
        }
    }
}

