/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.fragment;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import io.rong.imkit.fragment.BaseFragment;

public abstract class UriFragment
extends BaseFragment {
    public static final String RONG_URI = "RONG_URI";
    private boolean mViewCreated;
    private Uri mUri;
    private IActionBarHandler mBarHandler;

    protected Bundle obtainUriBundle(Uri uri) {
        Bundle args = new Bundle();
        args.putParcelable(RONG_URI, (Parcelable)uri);
        return args;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.mUri == null) {
            this.mUri = savedInstanceState == null ? this.getActivity().getIntent().getData() : (Uri)savedInstanceState.getParcelable(RONG_URI);
        }
        this.mViewCreated = true;
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getUri() != null) {
            this.initFragment(this.getUri());
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onPause() {
        super.onPause();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        outState.putParcelable(RONG_URI, (Parcelable)this.getUri());
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onRestoreUI() {
        if (this.getUri() != null) {
            this.initFragment(this.getUri());
        }
    }

    public void setActionBarHandler(IActionBarHandler mBarHandler) {
        this.mBarHandler = mBarHandler;
    }

    protected IActionBarHandler getActionBarHandler() {
        return this.mBarHandler;
    }

    public Uri getUri() {
        return this.mUri;
    }

    public void setUri(Uri uri) {
        this.mUri = uri;
        if (this.mViewCreated) {
            this.initFragment(uri);
        }
    }

    protected abstract void initFragment(Uri var1);

    @Override
    public boolean onBackPressed() {
        return false;
    }

    protected static interface IActionBarHandler {
        public void onTitleChanged(CharSequence var1);

        public void onUnreadCountChanged(int var1);
    }
}

