/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.mention;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import android.widget.EditText;
import io.rong.common.RLog;
import io.rong.imkit.RongContext;
import io.rong.imkit.RongIM;
import io.rong.imkit.mention.IMentionedInputListener;
import io.rong.imkit.mention.ITextInputListener;
import io.rong.imkit.mention.MemberMentionedActivity;
import io.rong.imkit.mention.MentionBlock;
import io.rong.imkit.mention.MentionInstance;
import io.rong.imkit.model.GroupUserInfo;
import io.rong.imkit.userInfoCache.RongUserInfoManager;
import io.rong.imlib.model.Conversation;
import io.rong.imlib.model.MentionedInfo;
import io.rong.imlib.model.UserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.json.JSONArray;

public class RongMentionManager
implements ITextInputListener {
    private static String TAG = "RongMentionManager";
    private Stack<MentionInstance> stack = new Stack();
    private RongIM.IGroupMembersProvider mGroupMembersProvider;
    private IMentionedInputListener mMentionedInputListener;

    private RongMentionManager() {
    }

    public static RongMentionManager getInstance() {
        return SingletonHolder.sInstance;
    }

    public void createInstance(Conversation.ConversationType conversationType, String targetId, EditText inputEditText) {
        MentionInstance mentionInstance;
        RLog.i((String)TAG, (String)"createInstance");
        String key = conversationType.getName() + targetId;
        if (this.stack.size() > 0) {
            mentionInstance = this.stack.peek();
            if (mentionInstance.key.equals(key)) {
                return;
            }
        }
        mentionInstance = new MentionInstance();
        mentionInstance.key = key;
        mentionInstance.mentionBlocks = new ArrayList<MentionBlock>();
        mentionInstance.inputEditText = inputEditText;
        this.stack.add(mentionInstance);
    }

    public void destroyInstance(Conversation.ConversationType conversationType, String targetId) {
        RLog.i((String)TAG, (String)"destroyInstance");
        if (this.stack.size() > 0) {
            MentionInstance instance = this.stack.peek();
            if (instance.key.equals(conversationType.getName() + targetId)) {
                this.stack.pop();
            } else {
                RLog.e((String)TAG, (String)("Invalid MentionInstance : " + instance.key));
            }
        } else {
            RLog.e((String)TAG, (String)"Invalid MentionInstance.");
        }
    }

    public void mentionMember(Conversation.ConversationType conversationType, String targetId, String userId) {
        GroupUserInfo groupUserInfo;
        RLog.d((String)TAG, (String)("mentionMember " + userId));
        if (TextUtils.isEmpty((CharSequence)userId) || conversationType == null || TextUtils.isEmpty((CharSequence)targetId) || this.stack.size() == 0) {
            RLog.e((String)TAG, (String)"Illegal argument");
            return;
        }
        String key = conversationType.getName() + targetId;
        MentionInstance instance = this.stack.peek();
        if (instance == null || !instance.key.equals(key)) {
            RLog.e((String)TAG, (String)("Invalid mention instance : " + key));
            return;
        }
        UserInfo userInfo = RongUserInfoManager.getInstance().getUserInfo(userId);
        if (conversationType == Conversation.ConversationType.GROUP && RongContext.getInstance().getGroupUserInfoProvider() != null && (groupUserInfo = RongContext.getInstance().getGroupUserInfoProvider().getGroupUserInfo(targetId, userId)) != null && groupUserInfo.getNickname() != null && !"".equals(groupUserInfo.getNickname().trim())) {
            userInfo.setName(groupUserInfo.getNickname());
        }
        this.addMentionedMember(userInfo, 0);
    }

    public void mentionMember(UserInfo userInfo) {
        if (userInfo == null || TextUtils.isEmpty((CharSequence)userInfo.getUserId())) {
            RLog.e((String)TAG, (String)"Invalid userInfo");
            return;
        }
        this.addMentionedMember(userInfo, 1);
    }

    public String getMentionBlockInfo() {
        if (this.stack.size() > 0) {
            MentionInstance mentionInstance = this.stack.peek();
            if (mentionInstance.mentionBlocks != null && !mentionInstance.mentionBlocks.isEmpty()) {
                JSONArray jsonArray = new JSONArray();
                for (MentionBlock mentionBlock : mentionInstance.mentionBlocks) {
                    jsonArray.put((Object)mentionBlock.toJson());
                }
                return jsonArray.toString();
            }
            return null;
        }
        return null;
    }

    void addMentionBlock(MentionBlock mentionBlock) {
        if (this.stack.size() > 0) {
            MentionInstance mentionInstance = this.stack.peek();
            mentionInstance.mentionBlocks.add(mentionBlock);
        }
    }

    private void addMentionedMember(UserInfo userInfo, int from) {
        if (this.stack.size() > 0) {
            MentionInstance mentionInstance = this.stack.peek();
            EditText editText = mentionInstance.inputEditText;
            if (userInfo != null && editText != null) {
                String mentionContent = from == 0 ? "@" + userInfo.getName() + " " : userInfo.getName() + " ";
                int len = mentionContent.length();
                int cursorPos = editText.getSelectionStart();
                MentionBlock brokenBlock = this.getBrokenMentionedBlock(cursorPos, mentionInstance.mentionBlocks);
                if (brokenBlock != null) {
                    mentionInstance.mentionBlocks.remove(brokenBlock);
                }
                MentionBlock mentionBlock = new MentionBlock();
                mentionBlock.userId = userInfo.getUserId();
                mentionBlock.offset = false;
                mentionBlock.name = userInfo.getName();
                mentionBlock.start = from == 1 ? cursorPos - 1 : cursorPos;
                mentionBlock.end = cursorPos + len;
                mentionInstance.mentionBlocks.add(mentionBlock);
                editText.getEditableText().insert(cursorPos, (CharSequence)mentionContent);
                editText.setSelection(cursorPos + len);
                mentionBlock.offset = true;
            }
        }
    }

    private MentionBlock getBrokenMentionedBlock(int cursorPos, List<MentionBlock> blocks) {
        MentionBlock brokenBlock = null;
        for (MentionBlock block : blocks) {
            if (!block.offset || cursorPos >= block.end || cursorPos <= block.start) continue;
            brokenBlock = block;
            break;
        }
        return brokenBlock;
    }

    private void offsetMentionedBlocks(int cursorPos, int offset, List<MentionBlock> blocks) {
        for (MentionBlock block : blocks) {
            if (cursorPos <= block.start && block.offset) {
                block.start += offset;
                block.end += offset;
            }
            block.offset = true;
        }
    }

    private MentionBlock getDeleteMentionedBlock(int cursorPos, List<MentionBlock> blocks) {
        MentionBlock deleteBlock = null;
        for (MentionBlock block : blocks) {
            if (cursorPos != block.end) continue;
            deleteBlock = block;
            break;
        }
        return deleteBlock;
    }

    @Override
    public void onTextEdit(Conversation.ConversationType conversationType, String targetId, int cursorPos, int offset, String text) {
        MentionBlock brokenBlock;
        RLog.d((String)TAG, (String)("onTextEdit " + cursorPos + ", " + text));
        if (this.stack == null || this.stack.size() == 0) {
            RLog.w((String)TAG, (String)"onTextEdit ignore.");
            return;
        }
        MentionInstance mentionInstance = this.stack.peek();
        if (!mentionInstance.key.equals(conversationType.getName() + targetId)) {
            RLog.w((String)TAG, (String)"onTextEdit ignore conversation.");
            return;
        }
        if (offset == 1 && !TextUtils.isEmpty((CharSequence)text)) {
            boolean showMention = false;
            if (cursorPos == 0) {
                String str = text.substring(0, 1);
                showMention = str.equals("@");
            } else {
                String preChar = text.substring(cursorPos - 1, cursorPos);
                String str = text.substring(cursorPos, cursorPos + 1);
                if (str.equals("@") && !preChar.matches("^[a-zA-Z]*") && !preChar.matches("^\\d+$")) {
                    showMention = true;
                }
            }
            if (showMention && (this.mMentionedInputListener == null || !this.mMentionedInputListener.onMentionedInput(conversationType, targetId))) {
                Intent intent = new Intent((Context)RongContext.getInstance(), MemberMentionedActivity.class);
                intent.putExtra("conversationType", conversationType.getValue());
                intent.putExtra("targetId", targetId);
                intent.setFlags(0x10000000);
                RongContext.getInstance().startActivity(intent);
            }
        }
        if ((brokenBlock = this.getBrokenMentionedBlock(cursorPos, mentionInstance.mentionBlocks)) != null) {
            mentionInstance.mentionBlocks.remove(brokenBlock);
        }
        this.offsetMentionedBlocks(cursorPos, offset, mentionInstance.mentionBlocks);
    }

    @Override
    public MentionedInfo onSendButtonClick() {
        if (this.stack.size() > 0) {
            ArrayList<String> userIds = new ArrayList<String>();
            MentionInstance curInstance = this.stack.peek();
            for (MentionBlock block : curInstance.mentionBlocks) {
                if (userIds.contains(block.userId)) continue;
                userIds.add(block.userId);
            }
            if (userIds.size() > 0) {
                curInstance.mentionBlocks.clear();
                return new MentionedInfo(MentionedInfo.MentionedType.PART, userIds, null);
            }
        }
        return null;
    }

    @Override
    public void onDeleteClick(Conversation.ConversationType type, String targetId, EditText editText, int cursorPos) {
        RLog.d((String)TAG, (String)("onTextEdit " + cursorPos));
        if (this.stack.size() > 0 && cursorPos > 0) {
            MentionBlock deleteBlock;
            MentionInstance mentionInstance = this.stack.peek();
            if (mentionInstance.key.equals(type.getName() + targetId) && (deleteBlock = this.getDeleteMentionedBlock(cursorPos, mentionInstance.mentionBlocks)) != null) {
                mentionInstance.mentionBlocks.remove(deleteBlock);
                String delText = deleteBlock.name;
                int start = cursorPos - delText.length() - 1;
                editText.getEditableText().delete(start, cursorPos);
                editText.setSelection(start);
            }
        }
    }

    public void setGroupMembersProvider(RongIM.IGroupMembersProvider groupMembersProvider) {
        this.mGroupMembersProvider = groupMembersProvider;
    }

    public RongIM.IGroupMembersProvider getGroupMembersProvider() {
        return this.mGroupMembersProvider;
    }

    public void setMentionedInputListener(IMentionedInputListener listener) {
        this.mMentionedInputListener = listener;
    }

    private static class SingletonHolder {
        static RongMentionManager sInstance = new RongMentionManager();

        private SingletonHolder() {
        }
    }
}

