/*
 * Decompiled with CFR 0.152.
 */
package io.rong.imkit.model;

import android.text.TextUtils;
import io.rong.common.RLog;
import io.rong.imlib.model.Conversation;

public final class ConversationKey {
    public static final String SEPARATOR = "#@6RONG_CLOUD9@#";
    private String key;
    private String targetId;
    private Conversation.ConversationType type;

    private ConversationKey() {
    }

    public static ConversationKey obtain(String targetId, Conversation.ConversationType type) {
        if (!TextUtils.isEmpty((CharSequence)targetId) && type != null) {
            ConversationKey conversationKey = new ConversationKey();
            conversationKey.setTargetId(targetId);
            conversationKey.setType(type);
            conversationKey.setKey(targetId + SEPARATOR + type.getValue());
            return conversationKey;
        }
        return null;
    }

    public static ConversationKey obtain(String key) {
        if (!TextUtils.isEmpty((CharSequence)key) && key.contains(SEPARATOR)) {
            ConversationKey conversationKey = new ConversationKey();
            if (key.contains(SEPARATOR)) {
                String[] array2 = key.split(SEPARATOR);
                conversationKey.setTargetId(array2[0]);
                try {
                    conversationKey.setType(Conversation.ConversationType.setValue((int)Integer.parseInt(array2[1])));
                }
                catch (NumberFormatException e) {
                    RLog.e((String)"ConversationKey ", (String)"NumberFormatException");
                    return null;
                }
                return conversationKey;
            }
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public Conversation.ConversationType getType() {
        return this.type;
    }

    public void setType(Conversation.ConversationType type) {
        this.type = type;
    }
}

